package com.northpool.commons.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    
    private ZipUtils(){
    }
    
    public static void doCompress(String srcFile, String zipFile,String wipeHead) throws Exception {
        doCompress(new File(srcFile), new File(zipFile),wipeHead);
    }
    
    /**
     * 文件压缩
     * @param srcFile 目录或者单个文件
     * @param zipFile 压缩后的ZIP文件
     * @throws Exception 
     */
    public static void doCompress(File srcFile, File zipFile,String wipeHead) throws Exception {
        ZipOutputStream out = null;
        FileOutputStream fout = new FileOutputStream(zipFile);
        try {
            out = new ZipOutputStream(fout);
            doCompress(srcFile, out,wipeHead);
        } catch (Exception e) {
            throw e;
        } finally {
            out.close();//记得关闭资源
            fout.close();
        }
    }
    
    public static void doCompress(String filelName, ZipOutputStream out,String wipeHead) throws IOException{
        doCompress(new File(filelName), out, wipeHead);
    }
    
    public static void doCompress(File file, ZipOutputStream out,String wipeHead) throws IOException{
        doCompress(file, out, "",true,wipeHead);
    }
    
    public static void doCompress(File inFile, ZipOutputStream out, String dir,Boolean saveDir,String wipeHead) throws IOException {
        if ( inFile.isDirectory() ) {
            File[] files = inFile.listFiles();
            if (files!=null && files.length>0) {
                for (File file : files) {
                	String name = inFile.getName();
                	
                	if(saveDir){
	                    
	                    if (!wipeHead.equals(name)) {
	                    	if(!"".equals(dir)){
	                    		name = dir + "/" + name;
	                    	}
	                        
	                    }else{
	                    	name = "";
	                    }
                	}else{
                		if(inFile.isDirectory()){
                			name = "";
                		}else{
                			name = file.getName();
                		}
                		
                	}
                    ZipUtils.doCompress(file, out, name,true,wipeHead);
                }
            }
        } else {
             ZipUtils.doZip(inFile, out, dir);
        }
    }
    
    public static void doZip(File inFile, ZipOutputStream out, String dir) throws IOException {
        String entryName = null;
        if (!"".equals(dir)) {
            entryName = dir + "/" + inFile.getName();
        } else {
            entryName = inFile.getName();
        }
        ZipEntry entry = new ZipEntry(entryName);
        out.putNextEntry(entry);
        
        int len = 0 ;
        byte[] buffer = new byte[1024];
        FileInputStream fis = new FileInputStream(inFile);
        while ((len = fis.read(buffer)) > 0) {
            out.write(buffer, 0, len);
            out.flush();
        }
        out.closeEntry();
        fis.close();
    }

    /**
     * 解压zip
     * @param zipFile zip文件
     * @param destination 目标路径
     * @throws IOException
     */
    public static void unzip(File zipFile, File destination) throws IOException {
        if (destination.exists() && destination.isDirectory()) {
            ZipInputStream zipInputStream = null;
            try {
                zipInputStream = new ZipInputStream(new FileInputStream(zipFile));
                byte[] buf = new byte[1024];
                for (ZipEntry zipEntry = zipInputStream.getNextEntry(); zipEntry != null; zipEntry = zipInputStream.getNextEntry()) {
                    String entryName = zipEntry.getName();
                    File newFile = new File(destination, entryName);
                    if (zipEntry.isDirectory()) {
                        newFile.mkdirs();
                    } else {
                        newFile.getParentFile().mkdirs();
                        FileOutputStream fileoutputstream = null;
                        try {
                            fileoutputstream = new FileOutputStream(newFile);
                            int n;
                            while ((n = zipInputStream.read(buf, 0, 1024)) > -1) {
                                fileoutputstream.write(buf, 0, n);
                            }
                        } finally {
                            if (fileoutputstream != null) {
                                fileoutputstream.close();
                            }
                        }
                    }
                }
            } finally {
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid destination: " + destination.getCanonicalPath());
        }
    }



}