package com.northpool.pixel.resmple;

import java.nio.ByteBuffer;

public class Resample {
	
	public enum Mode{
		modeNearestNeighbour,
		modeBilinear,
		modeBicubic
	}
	
	public static final int modeNearestNeighbour = 0;
	public static final int modeBilinear = 1;
	public static final int modeBicubic = 2;
	
	static Fn1DResamplingFunction get1DResamplingFunction (Mode mode) {
	   
	    switch (mode) {
	        case modeNearestNeighbour:

	            return NearestNeighbour.INSTANCE;

	        case modeBilinear:
	          

	            return Resample1DBilinear.INSTANCE;

	        case modeBicubic:

	            return Resample1DBicubic.INSTANCE;

	        default:
	        	 throw new RuntimeException("No resampling function for mode : " + mode.name());
	    }
	}
	
	
	
	
	public static ImageSrc resampleImageFromBuffer (ImageSrc image,int channelSize,int dstWidth,int dstHeight,Mode mode) {	// , fnCreateImage
		Fn1DResamplingFunction function = get1DResamplingFunction(mode);

	    int numBytesPerPixel = channelSize;	// Assume that the pixel format is RGBA.

	    int srcWidth = image.width;
	    int srcHeight = image.height;
	    int srcBytesPerLine = srcWidth * numBytesPerPixel;
	    ByteBuffer srcBuffer = image.dstBuffer;

	    int intermediateWidth = dstWidth;
	    int intermediateHeight = srcHeight;
	    int intermediateBytesPerLine = dstWidth * numBytesPerPixel;
	    ByteBuffer intermediateBuffer = ByteBuffer.allocateDirect(intermediateHeight * intermediateBytesPerLine);

	    int dstBytesPerLine = intermediateBytesPerLine;
	    //const dstBuffer = Buffer.alloc(dstHeight * dstBytesPerLine);
	    ByteBuffer dstBuffer = ByteBuffer.allocateDirect(dstHeight * dstBytesPerLine);

	    // 1) Resample horizontally from srcBuffer to intermediateBuffer

	    for (int row = 0; row < srcHeight; row++) {
	    	function.resampling(intermediateBuffer, row * intermediateBytesPerLine, intermediateWidth, numBytesPerPixel, srcBuffer, row * srcBytesPerLine, srcWidth, numBytesPerPixel, numBytesPerPixel);
	    }

	    // 2) Resample vertically from intermediateBuffer to dstBuffer

	    for (int col = 0; col < intermediateWidth; col++) {
	    	function.resampling(dstBuffer, col * numBytesPerPixel, dstHeight, dstBytesPerLine, intermediateBuffer, col * numBytesPerPixel, intermediateHeight, intermediateBytesPerLine, numBytesPerPixel);
	    }
	    
	    return new ImageSrc(dstBuffer,dstWidth,dstHeight,numBytesPerPixel);

	}
}
