package com.northpool.pixel.resmple;

import java.nio.ByteBuffer;

import com.northpool.commons.bits.UNumber;

public class Resample1DBicubic implements Fn1DResamplingFunction{

	public static final Resample1DBicubic INSTANCE = new Resample1DBicubic();
	
	static final double B = 0;
	
	static final double C = 0.5;
	
	static final byte b0 = (byte)0;
	
	double getBicubicWeight (double x) {
        x = Math.abs(x);

        if (x < 1) {
            // k(x) = (1/6) * (12 - 9B - 6C) * |x|^3 + (-18 + 12B + 6C) * |x|^2                      + (6 - 2B)			if |x| < 1
            return (((12 - 9 * B - 6 * C) * x + (-18 + 12 * B + 6 * C)) * x * x + 6 - 2 * B) / 6;
        } else if (x < 2) {
            // k(x) = (1/6) * (-B - 6C)      * |x|^3 + (6B + 30C)       * |x|^2 + (-12B - 48C) * |x| + (8B + 24C)		if 1 <= |x| < 2
            //return (((((-B - 6 * C) * x) + (6 * B + 30 * C) * x) - (12 * B + 48 * C) * x) + 8 * B + 24 * C) / 6;
            return ((-B - 6 * C) * x + (6 * B + 30 * C) * x - (12 * B + 48 * C) * x + 8 * B + 24 * C) / 6;
        } else {
            // k(x) = 0																									otherwise
            return 0;
        }
    };
	
	
	@Override
	public void resampling(ByteBuffer dstBuffer, int dstInitialOffset, int numDstPixels, int dstPixelStride,
			ByteBuffer srcBuffer, int srcInitialOffset, int numSrcPixels, int srcPixelStride, int numBytesPerPixel) {
		// TODO Auto-generated method stub
		int dstPixelOffsetInBuffer = dstInitialOffset;
	    int accumulator = 0;

	    for (int dstPixelIndex = 0; dstPixelIndex < numDstPixels; dstPixelIndex++) {
	        int dstPixelIndexInSrcSpace = accumulator / numDstPixels;
	        int srcPixelIndex = (int)(dstPixelIndexInSrcSpace);
	        int firstSrcPixelIndex = Math.max(srcPixelIndex - 1, 0);
	        int lastSrcPixelIndex = Math.min(srcPixelIndex + 2, numSrcPixels - 1);
	        double accumulator3 = 0;
	        double accumulator2 = 0;
	        double accumulator1 = 0;
	        double accumulator0 = 0;
	        int totalWeight = 0;
	        int srcPixelOffsetInBuffer = firstSrcPixelIndex * srcPixelStride + srcInitialOffset;		// We need a truncating integer division operator.

	        for (int srcPixelIndexInRun = firstSrcPixelIndex; srcPixelIndexInRun <= lastSrcPixelIndex; srcPixelIndexInRun++) {
	            //const srcPixelWeight = getBicubicWeight(srcPixelIndexInRun - dstPixelIndexInSrcSpace);
	        	double srcPixelWeight = getBicubicWeight((srcPixelIndex - dstPixelIndexInSrcSpace) * numDstPixels / numSrcPixels);

	            switch (numBytesPerPixel) {
	                case 4:
	                    accumulator3 += UNumber.getUint8(srcBuffer,(srcPixelOffsetInBuffer + 3)) * srcPixelWeight;
	                case 3:		// eslint-disable-line
	                	accumulator2 += UNumber.getUint8(srcBuffer,(srcPixelOffsetInBuffer + 2)) * srcPixelWeight;
	                	accumulator1 += UNumber.getUint8(srcBuffer,(srcPixelOffsetInBuffer + 1)) * srcPixelWeight;
	                 //   accumulator2 += srcBuffer[srcPixelOffsetInBuffer + 2] * srcPixelWeight;
	                  //  accumulator1 += srcBuffer[srcPixelOffsetInBuffer + 1] * srcPixelWeight;
	                case 1:		// eslint-disable-line
	                	accumulator0 += UNumber.getUint8(srcBuffer,(srcPixelOffsetInBuffer + 0)) * srcPixelWeight;
	                 //   accumulator0 += srcBuffer[srcPixelOffsetInBuffer + 0] * srcPixelWeight;
	                default:	// eslint-disable-line
	                    break;
	            }

	            totalWeight += srcPixelWeight;
	            srcPixelOffsetInBuffer += srcPixelStride;
	        }

	        if (totalWeight > 0) {

	            switch (numBytesPerPixel) {
	                case 4:
	                    dstBuffer.put((dstPixelOffsetInBuffer + 3) ,(byte)(accumulator3 / totalWeight)); // Or * inverseOfTotalWeight;
	                case 3:		// eslint-disable-line
	                	dstBuffer.put((dstPixelOffsetInBuffer + 2) ,(byte)(accumulator2 / totalWeight));
	                	dstBuffer.put((dstPixelOffsetInBuffer + 1) ,(byte)(accumulator1 / totalWeight));
	                   // dstBuffer[dstPixelOffsetInBuffer + 2] = accumulator2 / totalWeight;
	                  //  dstBuffer[dstPixelOffsetInBuffer + 1] = accumulator1 / totalWeight;
	                case 1:		// eslint-disable-line
	                	dstBuffer.put((dstPixelOffsetInBuffer) ,(byte)(accumulator0 / totalWeight));
	                //    dstBuffer[dstPixelOffsetInBuffer + 0] = accumulator0 / totalWeight;
	                default:	// eslint-disable-line
	                    break;
	            }
	        } else {

	            switch (numBytesPerPixel) {
	                case 4:
	                    dstBuffer.put(dstPixelOffsetInBuffer + 3 , b0);
	                case 3:		// eslint-disable-line
	                	dstBuffer.put(dstPixelOffsetInBuffer + 2 , b0);
	                	dstBuffer.put(dstPixelOffsetInBuffer + 1 , b0);
	                   // dstBuffer[dstPixelOffsetInBuffer + 2] = 0;
	                  //  dstBuffer[dstPixelOffsetInBuffer + 1] = 0;
	                case 1:		// eslint-disable-line
	                	dstBuffer.put(dstPixelOffsetInBuffer , b0);
	                   // dstBuffer[dstPixelOffsetInBuffer + 0] = 0;
	                default:	// eslint-disable-line
	                    break;
	            }
	        }

	        dstPixelOffsetInBuffer += dstPixelStride;
	        accumulator += numSrcPixels;
	    }
	}

}
