package com.northpool.pixel.resmple;

import java.nio.ByteBuffer;

import com.northpool.commons.bits.UNumber;

public class Resample1DBilinear implements Fn1DResamplingFunction {
	
	public static final Resample1DBilinear INSTANCE = new Resample1DBilinear();
	
	@Override
	public void resampling(ByteBuffer dstBuffer, int dstInitialOffset, int numDstPixels, int dstPixelStride,
			ByteBuffer srcBuffer, int srcInitialOffset, int numSrcPixels, int srcPixelStride, int numBytesPerPixel) {
		int accumulator = 0;

	    for (int dstPixelIndex = 0; dstPixelIndex < numDstPixels; dstPixelIndex++) {
	        int srcPixelIndexInRun = (int)(accumulator / numDstPixels);
	       
	        int srcPixelIndex = srcPixelIndexInRun * srcPixelStride + srcInitialOffset;		// We need a truncating integer division operator.

	        if (srcPixelIndexInRun >= numSrcPixels - 1) {
	            switch (numBytesPerPixel) {
	                case 4:
	                    dstBuffer.put(dstInitialOffset + 3,srcBuffer.get(srcPixelIndex + 3));
	                case 3:		// eslint-disable-line
	                    dstBuffer.put(dstInitialOffset + 2 , srcBuffer.get(srcPixelIndex + 2));
	                    dstBuffer.put(dstInitialOffset + 1 , srcBuffer.get(srcPixelIndex + 1));
	                case 1:		// eslint-disable-line
	                	dstBuffer.put(dstInitialOffset , srcBuffer.get(srcPixelIndex));
	                default:	// eslint-disable-line
	                    break;
	            }
	        } else {
	            int srcPixelIndex2 = (srcPixelIndexInRun + 1) * srcPixelStride + srcInitialOffset;		// We need a truncating integer division operator.
	            int remainder = accumulator - srcPixelIndexInRun * numDstPixels;
	            int weight1 = numDstPixels - remainder;
	            int weight2 = remainder;
	            switch (numBytesPerPixel) {
	                case 4:
	                    dstBuffer.put(dstInitialOffset + 3 , (byte) ((UNumber.getUint8(srcBuffer, srcPixelIndex + 3) * weight1 + UNumber.getUint8(srcBuffer,srcPixelIndex2 + 3) * weight2) / numDstPixels));

	                   // dstBuffer[dstInitialOffset + 3] = (srcBuffer[srcPixelIndex + 3] * weight1 + srcBuffer[srcPixelIndex2 + 3] * weight2) / numDstPixels;
	                case 3:		// eslint-disable-line
	                    dstBuffer.put(dstInitialOffset + 2 , (byte) ((UNumber.getUint8(srcBuffer, srcPixelIndex + 2) * weight1 + UNumber.getUint8(srcBuffer,srcPixelIndex2 + 2) * weight2) / numDstPixels));
	                    dstBuffer.put(dstInitialOffset + 1 , (byte) ((UNumber.getUint8(srcBuffer, srcPixelIndex + 1) * weight1 + UNumber.getUint8(srcBuffer,srcPixelIndex2 + 1) * weight2) / numDstPixels));

	                  //  dstBuffer[dstInitialOffset + 2] = (srcBuffer[srcPixelIndex + 2] * weight1 + srcBuffer[srcPixelIndex2 + 2] * weight2) / numDstPixels;
	                  //  dstBuffer[dstInitialOffset + 1] = (srcBuffer[srcPixelIndex + 1] * weight1 + srcBuffer[srcPixelIndex2 + 1] * weight2) / numDstPixels;
	                case 1:		// eslint-disable-line
	                    dstBuffer.put(dstInitialOffset , (byte) ((UNumber.getUint8(srcBuffer, srcPixelIndex) * weight1 + UNumber.getUint8(srcBuffer,srcPixelIndex2) * weight2) / numDstPixels));

	                    //dstBuffer[dstInitialOffset] = (srcBuffer[srcPixelIndex] * weight1 + srcBuffer[srcPixelIndex2] * weight2) / numDstPixels;
	                default:	// eslint-disable-line
	                    break;
	            }
	        }

	        dstInitialOffset += dstPixelStride;
	        accumulator += numSrcPixels;
	    }
	}
}
