/**
　 * <p>Title: Geom.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * 
　 * 
　 * @date 2021年3月22日
　 * @version 1.0
*/
package com.northpool.spatial;


import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.checkerframework.checker.units.qual.A;
import org.locationtech.jts.geom.Geometry;

import com.alibaba.fastjson.util.Base64;
import com.northpool.commons.util.PackageUtil;
import com.northpool.spatial.Constants.SPATIAL_TYPE;
import com.northpool.spatial.geofeature.GeoBuffer;

/**
 * 
 *
 */
public class Geom {
    
    
    static final Map<SPATIAL_TYPE,GeomDecoder<Object>> DECODER_MAP ;
    static final Map<SPATIAL_TYPE,GeomEncoder<Object>> ENCODER_MAP ;
    
    
    public SPATIAL_TYPE getType() {
        return type;
    }

    static{
        HashMap<SPATIAL_TYPE,GeomDecoder<Object>> _DECODER_MAP = new HashMap<SPATIAL_TYPE,GeomDecoder<Object>>();
        HashMap<SPATIAL_TYPE,GeomEncoder<Object>> _ENCODER_MAP = new HashMap<SPATIAL_TYPE,GeomEncoder<Object>>();

        Set<Class<?>> clazzSetDecoder;
        Set<Class<?>> clazzSetEncoder;
        try {
            clazzSetDecoder = PackageUtil.findClassAnnotation("com.northpool.spatial", AGeomDecoder.class);
            clazzSetEncoder = PackageUtil.findClassAnnotation("com.northpool.spatial", AGeomEncoder.class);
        } catch (ClassNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            throw new RuntimeException("加载ITableBuilderMap失败," + e.getMessage());
        }
        clazzSetDecoder.forEach((clazz) -> {

            AGeomDecoder annotation = clazz.getAnnotation(AGeomDecoder.class);
            SPATIAL_TYPE type = annotation.type();
            @SuppressWarnings("unchecked")
            Class<? extends GeomDecoder<Object>> cla = (Class<? extends GeomDecoder<Object>>)clazz;
            try {
                _DECODER_MAP.put(type, cla.newInstance());
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
                throw new RuntimeException(e);
            } 
        });
        
        clazzSetEncoder.forEach((clazz) -> {

            AGeomEncoder annotation = clazz.getAnnotation(AGeomEncoder.class);
            SPATIAL_TYPE type = annotation.type();
            @SuppressWarnings("unchecked")
            Class<? extends GeomEncoder<Object>> cla = (Class<? extends GeomEncoder<Object>>)clazz;
            try {
                _ENCODER_MAP.put(type, cla.newInstance());
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
                throw new RuntimeException(e);
            } 
        });
        
        DECODER_MAP = Collections.unmodifiableMap(_DECODER_MAP);
        ENCODER_MAP = Collections.unmodifiableMap(_ENCODER_MAP);
    }
    
    SPATIAL_TYPE type;
    
    Object originGeom;
    
    int srid = 0;
    
    public Object getOriginGeom() {
        return originGeom;
    }

   
   
    
    public Geom(SPATIAL_TYPE type,Object originGeom){
        this.originGeom = originGeom;
        this.type = type;
    }
    
    public void setSRID(int srid) {
        this.srid = srid;
    }

    public String toWkt() {
        return this.toGeoBuffer().toWkt();
    }
    
    public String toString(){
        return this.toGeoBuffer().toJTSGeometry().toString();
    }
    
    public Geometry toJTSGeometry(){
        return this.toGeoBuffer().toJTSGeometry();
    }
    
    public GeoBuffer toGeoBuffer(){
        try {
            GeomDecoder<Object> decoder = DECODER_MAP.get(this.type);
            if(decoder == null){
                throw new RuntimeException("转换器不支持空间类型:" + type.name());
            }
            GeoBuffer geoBuffer = decoder.toGeoBuffer(this.originGeom);
          //  geoBuffer.setSRID(this.srid);
            return geoBuffer;
            
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
    
    
    
    
    /**
     * 转换,暂时方法,以后需要转换成GeomConverter模式
     * @param type
     * @return
     */
    public void changeType(SPATIAL_TYPE type){
        if(type == this.type){
            return;
        }
        GeoBuffer geoBuffer = this.toGeoBuffer();
        geoBuffer.setSRID(this.srid);
        GeomEncoder<Object> encoder = ENCODER_MAP.get(type);
        if(encoder == null){
            throw new RuntimeException("不支持转换到空间类型" + type.name());
        }
        this.originGeom = encoder.fromGeoBuffer(geoBuffer);
        this.type = type;
    }
    
    public static void main(String[] aaaa){
        
        String aaa = "0106000020021200000300000001030000000100000006000000088CFF2DB6875C40286C98F7A6694140D043FAC4AA875C40981EDECFA5694140A80CE3ADA1875C40E01B7349066A4140E8E9D6DCAA875C40280CAD49066A4140709EABADB6875C4058A48604A7694140088CFF2DB6875C40286C98F7A669414001030000000100000008000000F82245CC5A875C40C0896DA39D694140606E0D1847875C40704131C79A69414050B4CB2A47875C40E0FF5A949E694140082969645A875C4098067250B8694140A84F1F1962875C4020B72B53BB6941406087D59770875C40F80DAB1DBB694140F0E61E676E875C403044FDBA9F694140F82245CC5A875C40C0896DA39D69414001030000000100000007000000487BD2E5FE875C4058290FE79B69414040A233CEFE875C40F01BC29A8F694140B8052059F8875C40689F210190694140F09F9041F8875C40500062D0916941402833000000885C40883C9768B36941402833000000885C4080372D179E694140487BD2E5FE875C4058290FE79B694140";
       // String aaa = "AQYAACACEgAAAwAAAAEDAAAAAQAAAAYAAAAIjP8ttodcQChsmPemaUFA0EP6xKqHXECYHt7PpWlBQKgM462hh1xA4BtzSQZqQUDo6dbcqodcQCgMrUkGakFAcJ6rrbaHXEBYpIYEp2lBQAiM/y22h1xAKGyY96ZpQUABAwAAAAEAAAAIAAAA+CJFzFqHXEDAiW2jnWlBQGBuDRhHh1xAcEExx5ppQUBQtMsqR4dcQOD/WpSeaUFACClpZFqHXECYBnJQuGlBQKhPHxlih1xAILcrU7tpQUBgh9WXcIdcQPgNqx27aUFA8OYeZ26HXEAwRP26n2lBQPgiRcxah1xAwIlto51pQUABAwAAAAEAAAAHAAAASHvS5f6HXEBYKQ/nm2lBQECiM87+h1xA8BvCmo9pQUC4BSBZ+IdcQGifIQGQaUFA8J+QQfiHXEBQAGLQkWlBQCgzAAAAiFxAiDyXaLNpQUAoMwAAAIhcQIA3LReeaUFASHvS5f6HXEBYKQ/nm2lBQA==";
       
        System.out.println(aaa.length());
        byte[] c = Base64.decodeFast(aaa);
        System.out.println(c.length);
    }
    
    
}
