package com.northpool.spatial.geofeature;


import com.northpool.exception.Message;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;

public class GeoFeature<T> {
	private T geo;

	private Object[] property;

	double[] bbox;

	static final ThreadLocal<WKBReader> wkbReaderLocal = new ThreadLocal<>();

	public Object[] getProperty() {
		return property;
	}
	public double[] getBbox(){
		if (this.bbox != null){
			return this.bbox;
		}
		if (this.geo instanceof Geometry){
			Envelope envelope = ((Geometry)geo).getEnvelopeInternal();
			this.bbox = new double[]{envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY()};
		}else if (this.geo instanceof GeoBuffer){
			this.bbox = ((GeoBuffer) this.geo).getBBOX();
		}
		return this.bbox;
	}
	public T getGeo() {
		return geo;
	}

	public Geometry getGeometry(){
		if (this.geo instanceof Geometry){
			return  ((Geometry)geo);
		}else if (this.geo instanceof GeoBuffer){
			return ((GeoBuffer) this.geo).toJTSGeometry();
		}else if (this.geo instanceof byte[]){
			try {
				return getWkbReader().read((byte[])geo);
			} catch (ParseException e) {
				throw new Message("wkb解析失败");
			}
		}
		throw new UnsupportedOperationException("不支持的GeoFeature类型" + this.geo.getClass().getName());
	}


	public GeoFeature(Object[] property,T geo){
		 this.property = property;
		 this.geo = geo;
	}

	public GeoFeature(Object[] property,T geo, double[] bbox){
		this.property = property;
		this.geo = geo;
		this.bbox = bbox;
	}

	private static WKBReader getWkbReader(){
		WKBReader reader = wkbReaderLocal.get();
		if (reader == null){
			reader = new WKBReader();
			wkbReaderLocal.set(reader);
		}
		return reader;
	}
	
	
}
