/**
　 * <p>Title: GeoPart.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * 
　 * 
　 * @date 2020年5月21日
　 * @version 1.0
*/
package com.northpool.spatial.geofeature;

import com.northpool.commons.util.DoubleBuilder;
import com.northpool.spatial.Constants.GEO_TYPE;

/**
 * 
 *
 */
public class GeoPart {
	 
	public static enum RING_TYPE{
		outside,inside
	}
	
	protected DoubleBuilder doubleBuilder;
	protected RING_TYPE ringType = null;
	protected double minX;
	protected double minY;
	protected double maxX;
	protected double maxY;
	protected GeoBuffer geoBuffer;
	protected double minZ = Double.NaN;
	protected double maxZ = Double.NaN;
	
	public double[] getBBOX(){
		return new double[]{this.minX,this.minY,this.maxX,this.maxY}; 
	}
	
	public double[] zInterval(){
	    return new double[]{this.minZ,this.maxZ}; 
	}
	
	public void setZInterval(double minZ,double maxZ){
	    this.minZ = minZ;
	    this.maxZ = maxZ;
	}
	
	
	public int getCoordinateCount(){
	    return this.doubleBuilder.size() / this.getDimension();
	}
	
	public GeoPart(DoubleBuilder doubleBuilder,GeoBuffer geoBuffer){
		this.doubleBuilder = doubleBuilder;
		this.minX = doubleBuilder.get(0);
		this.minY = doubleBuilder.get(1);
		this.maxX = doubleBuilder.get(0);
		this.maxY = doubleBuilder.get(1);
		this.geoBuffer = geoBuffer;
	}
	
	//线顺逆时针顺序的构造函数
	GeoPart(DoubleBuilder doubleBuilder,double minX,double minY,double maxX,double maxY,GeoBuffer geoBuffer){
		this(doubleBuilder, minX, minY, maxX, maxY, geoBuffer, null);
	}
	//面构造函数,需要提供面环的顺逆信息
	GeoPart(DoubleBuilder doubleBuilder,double minX,double minY,double maxX,double maxY,GeoBuffer geoBuffer,RING_TYPE ringType){
		this.doubleBuilder = doubleBuilder;
		this.minX = minX;
		this.minY = minY;
		this.maxX = maxX;
		this.maxY = maxY;
	
		this.geoBuffer = geoBuffer;
		this.ringType = ringType;
	}
	
	
	
	public RING_TYPE getRingType() {
		return ringType;
	}

	public void setRingType(RING_TYPE ringType) {
		this.ringType = ringType;
	}

	public Integer getDimension() {
		return geoBuffer.dimension;
	}

	public Integer getSRID() {
		return geoBuffer.srid;
	}
	
	public GEO_TYPE getGeoType() {
		return geoBuffer.geoType;
	}
	
	
	public DoubleBuilder getDoubleBuilder() {
		return doubleBuilder;
	}
	public void setDoubleBuilder(DoubleBuilder doubleBuilder) {
		this.doubleBuilder = doubleBuilder;
	}
	
	public double getMinX() {
		return minX;
	}
	public void setMinX(double minX) {
		this.minX = minX;
	}
	public double getMinY() {
		return minY;
	}
	public void setMinY(double minY) {
		this.minY = minY;
	}
	public double getMaxX() {
		return maxX;
	}
	public void setMaxX(double maxX) {
		this.maxX = maxX;
	}
	public double getMaxY() {
		return maxY;
	}
	public void setMaxY(double maxY) {
		this.maxY = maxY;
	}
	public GeoBuffer getGeoBuffer() {
		return geoBuffer;
	}
	public void setGeoBuffer(GeoBuffer geoBuffer) {
		this.geoBuffer = geoBuffer;
	}

    public double getMinZ() {
        return minZ;
    }

    public void setMinZ(double minZ) {
        this.minZ = minZ;
    }

    public double getMaxZ() {
        return maxZ;
    }

    public void setMaxZ(double maxZ) {
        this.maxZ = maxZ;
    }
	
}
