package com.northpool.spatial.grid;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.northpool.spatial.Point;
import com.northpool.spatial.grid.Constants.GRID_UNIT;
import com.northpool.spatial.grid.extent.GridExtent;
import com.northpool.spatial.grid.impl.AbstractGrid;

public class CustomGrid extends AbstractGrid{
	
	Point originPoint;
	
	Map<Integer,Lod> levels = new HashMap<>();
	
	
	public CustomGrid(int base,GRID_UNIT unit,List<Lod> lods,Point originPoint,Point endPoint) {
        super();
        this.unit = unit;
        this.base = base;
        this.originPoint = originPoint;

       // this.beginLevel
        
      
 
        if(unit == Constants.GRID_UNIT.pixel){
            this.minX = (int)originPoint.x;
            this.minY = (int)originPoint.y;
            if(endPoint != null){
                this.maxX = endPoint.x;
                this.maxY = endPoint.y;
            }
        }else{
            this.minX = originPoint.x;
            this.maxY = originPoint.y;
            if(endPoint != null){
                this.maxX = endPoint.x;
                this.minY = endPoint.y;
            }
        }

        this._init(lods);
    }
	
	
	private void _init(List<Lod> lods){
        lods.sort( (o1,o2) ->{
           return o1.level - o2.level; 
        });
        this.beginLevel = lods.get(0).level;
        this.maxLevel = lods.get(lods.size() - 1).level;
        lods.stream().forEach( lod -> {
        	this.levels.put(lod.level, lod);
        });
    }
	
	public Double getResolution(int level) {
        Lod lod = this.levels.get(level);
        if(lod == null){
            return null;
        }
        return lod.resolution;
    }


	

	
	
}
