package com.northpool.spatial.grid;

import com.northpool.spatial.grid.Constants.GRID_UNIT;
import com.northpool.spatial.grid.extent.GridExtent;
import org.locationtech.proj4j.CoordinateReferenceSystem;

import java.util.List;


/**
 * 格网
 * 
 * 
 *
 */
public interface Grid {

	/**
	 * 根据LXY获得标准格网
	 * 
	 * @param level
	 * @param x
	 * @param y
	 * @return
	 * getGridExtent
	 */
	@Deprecated
	public GridExtent getExtent(int level, int x, int y);


	public GridExtent getGridExtentByKey(String key);


	/**
	 * 根据LXY获得标准格网
	 * 
	 * @param level
	 * @param x
	 * @param y
	 * @return
	 */
	public GridExtent getGridExtent(int level, int x, int y);


	/**
	 * 获得初始级别
	 * 
	 * @return
	 */
	public int getBeginLevel();

	

	/**
	 * 获得格网单位
	 * 
	 * @return
	 */
	public GRID_UNIT getUnit();
	
	/**
	 * 获得格网基准像素
	 * getBaseTileSize
	 * @return
	 */
	@Deprecated
	public int getBase();

	/**
	 * 获得格网基准像素
	 * 
	 * @return
	 */
	public int getBaseTileSize();
	/**
	 * 判断BBOX是否是该格网的基准格网，如果是就返回，不是就返回NULL
	 * 
	 * @param bbox
	 * @return
	 */
	// GridExtent isGridExtent(String bbox);

	/**
	 * 根据LEVEL获得精度
	 * 
	 * @param level
	 * @return
	 */
	public Double getResolution(int level);

	//public String toJson();

	/**
	 * 地图X坐标转换为瓦片X坐标
	 * 
	 * @param resolution
	 *            瓦片分辨率
	 * @param x
	 *            空间X坐标
	 * @return
	 */
	public double calculateX(double resolution, double x);

	/**
	 * 地图y坐标转换为瓦片x坐标
	 * 
	 * @param resolution
	 *            瓦片分辨率
	 * @param y
	 *            空间y坐标
	 * @return
	 */
	public double calculateY(double resolution, double y);

	public double getMinX();

	public double getMinY();

	public double getMaxX();

	public double getMaxY();
	/**
	 * 找到点在的瓦片
	 * @param x
	 * @param y
	 * @param level
	 * @return
	 */
	public GridExtent getPointToTile(double x,double y,int level);
	/**
	 * 加入扫描线，可以扫描图形使用格网
	 * @param points
	 * @param type
	 * @param level
	 * @return
	 */
	//public Set<Integer[]> scanline(double[][] points,int type,int level);
	/**
	 * 找到点对应格网的xyl的字符串
	 * @param x
	 * @param y
	 * @param level
	 * @return
	 */
	public String getPointToTileString(double x,double y,int level);
	
	
	public String getBBox();

	/*
	 * 设置分辨率数组
	 * */
	default void setResolutions(double[] resolution) {

	}

	void setMinX(int minX);

	void setMaxY(int maxY);

	default double[] getResolutions(){
		return null;
	};
	
	
	
	/**
	 * 根据BBOX和层级获得GridExtent array
	 * @param level
	 * @param minX
	 * @param minY
	 * @param maxX
	 * @param maxY
	 * @return
	 */
	public List<GridExtent> getGridExtentsByBBox(int level,double minX,double minY,double maxX,double maxY);
	
	public CoordinateReferenceSystem getProj();
	
	/**
	 * 根据bbox计算适宜的初始化层级
	 * @param bbox 四至范围
	 * @return 返回推荐适宜显示的开始层级
	 */
	public int getFitableBeginLevel(double[] bbox);

}