package com.northpool.spatial.grid.extent;

import com.northpool.spatial.grid.Grid;

/**
 * 格网范围
 * 
 * 
 *
 */
public interface GridExtent extends Extent {

	public int getX();

	public int getY();

	public Extent getExtentByBuffer(int percent);

	public GridExtent[] getDown(int downLevel);

	public double getResolution();

	public int getLevel();

	public Grid getGrid();

	public double getBuffer(int percent);
	
	/**
	 * 获得下级的四个瓦片
	 * @return
	 */
	public GridExtent[] getChildren();
	
	public String toJSON();

	public Integer getBufferSize();

	public void setBufferSize(Integer bufferSize);

	public String getKey();
}