package com.northpool.spatial.grid.extent.impl;

import com.northpool.spatial.Point;
import com.northpool.spatial.grid.extent.Extent.Extent4Point;

public abstract class AbstractExtent {

	public double bottom;
	public double left;
	public double right;
	public double top;
	protected String wkt;
	protected String BBOX;

	public AbstractExtent(String BBOX) {
		String[] boxs = BBOX.split(",");
		this.BBOX = BBOX;
		double left = Double.valueOf(boxs[0]);
		double bottom = Double.valueOf(boxs[1]);
		double right = Double.valueOf(boxs[2]);
		double top = Double.valueOf(boxs[3]);
		this.init(left, bottom, right, top);
	}

	public AbstractExtent(double left, double bottom, double right, double top) {
		this.BBOX = new StringBuilder().append(left).append(',').append(bottom).append(',').append(right).append(',').append(top).toString();
		//this.BBOX = left + "," + bottom + "," + right + "," + top;
		this.init(left, bottom,right, top);
	}

	private void init(double left, double bottom, double right, double top) {
		this.left = left;
		this.bottom = bottom;
		this.right = right;
		this.top = top;

		this.wkt = this.doWkt(left, bottom, right, top);
	}

	public double getBottom() {
		return bottom;
	}

	public double getLeft() {
		return left;
	}

	public double getRight() {
		return right;
	}

	public double getTop() {
		return top;
	}

	public String getBBOX() {
		return BBOX;
	}

	public String getWkt() {
		return wkt;
	}

	protected String doWkt(double left, double bottom, double right, double top) {
		String wkt = new StringBuilder().append("POLYGON ((")
				.append(left).append(' ').append(bottom).append(',')
				.append(right).append(' ').append(bottom).append(',')
				.append(right).append(' ').append(top).append(',')
				.append(left).append(' ').append(top).append(',')
				.append(left).append(' ').append(bottom).append(')').append(')').toString();
		
		/*String wkt = "POLYGON ((";
		wkt += left + " " + bottom + ",";
		wkt += right + " " + bottom + ",";
		wkt += right + " " + top + ",";
		wkt += left + " " + top + ",";
		wkt += left + " " + bottom + "))";*/
		
		return wkt;
	}



	public double[] bbox(){
		return new double[]{left,bottom,right,top};
	}
	
	
	public Integer bufferSize;
	
	public Integer getBufferSize() {
		return bufferSize;
	}

	public void setBufferSize(Integer bufferSize) {
		this.bufferSize = bufferSize;
	}
	
	public Extent4Point getBBoxCoordinates(){
		Extent4Point extent4Point = new Extent4Point(
				new Point(this.left,this.bottom),
				new Point(this.left,this.top),
				new Point(this.right,this.top),
				new Point(this.right,this.bottom)
        );
        return extent4Point;
    }
	


}
