package com.northpool.spatial.grid.extent.impl;


import com.northpool.spatial.grid.Grid;

import com.northpool.spatial.grid.extent.Extent;
import com.northpool.spatial.grid.extent.GridExtent;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.util.LinkedList;
/**
 * 增加buffer size参数
 * 
 *
 */
public class GridExtentImpl extends ExtentImpl implements GridExtent {

	protected int x;

	protected int y;

	protected int level;
	
	protected Grid grid;

	public double resolution;



	public GridExtentImpl(double left, double bottom, double right, double top, int level, Grid grid, int x, int y) {
		super(left, bottom, right, top);
		this.x = x;
		this.y = y;
		this.level = level;
		this.resolution = (double) grid.getResolution(level);
		this.grid = grid;
	}
	@Override
	public int getX() {
		return this.x;
	}
	@Override
	public int getY() {
		return this.y;
	}

	public int getL() {
		return this.grid.getBaseTileSize();
	}
	@Override
	public Extent getExtentByBuffer(int percent) {
		double buffer = this.getBuffer(percent);
		double left = this.left - buffer;
		double bottom = this.bottom - buffer;
		double right = this.right + buffer;
		double top = this.top + buffer;
		return new ExtentImpl(left, bottom, right, top);
	}

	@Override
	public GridExtent[] getDown(int downLevel) {
		if (downLevel <= 0) {
			return new GridExtent[] { this };
		}
		LinkedList<GridExtent> list = new LinkedList<>();

		int endLevel = this.level + downLevel;

		this.buildDownArray(this, list, endLevel);
		list.push(this);

		return list.toArray(new GridExtent[list.size()]);
	}

	/**
	 * 迭代构建瓦片的下级4个瓦片，知道结束的层级
	 * 
	 * @param extent
	 *            初始瓦片
	 * @param list
	 *            存放构建瓦片的集合
	 * @param endLevel
	 *            结束层级
	 */
	private void buildDownArray(GridExtent extent, LinkedList<GridExtent> list, int endLevel) {
		int x = extent.getX();
		int y = extent.getY();
		int l = extent.getLevel() + 1;
		GridExtent extent0 = this.grid.getGridExtent(l, x * 2, y * 2);
		if (extent0.getLevel() < endLevel) {
			this.buildDownArray(extent0, list, endLevel);
		}

		GridExtent extent1 = this.grid.getGridExtent(l, x * 2 + 1, y * 2);
		if (extent1.getLevel() < endLevel) {
			this.buildDownArray(extent1, list, endLevel);
		}
		GridExtent extent2 = this.grid.getGridExtent(l, x * 2, y * 2 + 1);
		if (extent2.getLevel() < endLevel) {
			this.buildDownArray(extent2, list, endLevel);
		}
		GridExtent extent3 = this.grid.getGridExtent(l, x * 2 + 1, y * 2 + 1);
		if (extent3.getLevel() < endLevel) {
			this.buildDownArray(extent3, list, endLevel);
		}
		list.push(extent0);
		list.push(extent1);
		list.push(extent2);
		list.push(extent3);
		
	}
	
	@Override
	public GridExtent[] getChildren(){
		LinkedList<GridExtent> list = new LinkedList<>();
		this.buildDownArray(this, list, this.level + 1);
		return list.toArray(new GridExtent[4]);
	}
	
	@Override
	public String toString() {
		return new StringBuilder().append("x = ").append(this.x).append(" y = ").append(this.y).append(" level = ").append(this.level).toString();
	}
	@Override
	public String toJSON(){
		return new StringBuilder().append(this.level).append('_').append(this.x).append('_').append(this.y).toString();
	}
	@Override
	public int getLevel() {
		return level;
	}
	@Override
	public double getResolution() {
		return resolution;
	}
	@Override
	public Grid getGrid() {
		return this.grid;
	}

	@Override
	public double getBuffer(int percent) {
		double buffer = this.grid.getBaseTileSize() * this.resolution * percent / 100;
		return buffer;
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) return true;

		if (o == null || getClass() != o.getClass()) return false;

		GridExtentImpl that = (GridExtentImpl) o;

		return new EqualsBuilder()
				.append(x, that.x)
				.append(y, that.y)
				.append(level, that.level)
				.isEquals();
	}

	@Override
	public int hashCode() {
		return new HashCodeBuilder(17, 37)
				.append(x)
				.append(y)
				.append(level)
				.toHashCode();
	}



	@Override
	public String getKey() {
		return new StringBuilder().append(this.level).append('_').append(this.x).append('_').append(this.y).toString();
	}
}
