package com.northpool.spatial.grid.impl;

import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;

import com.northpool.spatial.grid.Constants.GRID_UNIT;
import com.northpool.spatial.grid.QuadtreeGrid;
import com.northpool.spatial.grid.extent.GridExtent;





/**
 * 瓦片的四方树对象
 * 
 * @author zhangyi
 *
 */
/**
 * 
 *
 */
public abstract class QuadtreeImpl extends AbstractGrid implements QuadtreeGrid {

		
	private static double EMTPY = Double.NaN;


	/**
	 * 初始化
	 * 
	 * @param beginLevel
	 *            开始层级
	 * @param unit
	 *            瓦片初始数据的坐标系统：GridUnit.degrees:经纬度坐标；GridUnit.meter：平面坐标
	 * @param resolutionLevelBegin
	 *            瓦片的分辨率
	 */
	protected void init(Integer base,int beginLevel, GRID_UNIT unit) {
		this.base = base;// 一张瓦片的大小（像素）
		this.unit = unit;
		switch (unit) {
		case degree:// 经纬度坐标系的全球范围
			this.minX = -180d;
			this.minY = -90d;
			this.maxX = 180d;
			this.maxY = 90d;
			break;
		case meter:// 平面坐标的全球范围
			this.minX = -20037508d;
			this.minY = -20037508d;
			this.maxX = 20037508d;
			this.maxY = 20037508d;
			break;
		}

		this.beginLevel = beginLevel;
		
		int unitpixel = (int)(this.maxY - this.minY);

		
		// 计算1级地图一张瓦片的分辨率(一张256*256像素图片的分辨率=180度/256像素或40075016米/256像素)
		this.resolutionLevelBegin = (double) unitpixel / (double) this.base;
				
	}

	/**
	 * 根据地图层级计算瓦片的分辨率(方便计算每个瓦片应包含的空间范围)
	 */
	@Override
	public Double getResolution(int level) {
		// 根据初始的分辨率计算层级上每个瓦片的分辨率
		return (double) (this.resolutionLevelBegin / (Math.pow(2, level - this.beginLevel)));//幂运算
	}

	
	public GridExtent isGridExtent(String bbox) {
		return null;
	}
	
	public String toJson() {
		return null;
	}
	
	
	

	
	
	
	
	
	private Set<Long> polyRingCover(double[][] points,int level){
		//首先先简化
		
		double[][] newPoly = new double[points.length][];
		double resolution = this.getResolution(level);
		for(int index = 0;  index < newPoly.length; index ++){
			double[] doubleArr = points[index];
			double[] parent = new double[]{-1d,-1d};
			DoubleBuffer buffer = DoubleBuffer.allocate(doubleArr.length);
			for(int i = 0 ; i < doubleArr.length /2 ; i ++){
				double x = doubleArr[i * 2];
				double y = doubleArr[i * 2 + 1];
				//this.calculateX(resolution, x)
				double _x = (int)((x - this.getMinX()) / resolution) ; 
				double _y = (int)((this.getMaxY() - y) / resolution) ;
				if(parent[0] == -1 && parent[1] == -1){
					//如果没有
					parent[0] = _x;
					parent[1] = _y;
					buffer.put(_x);
					buffer.put(_y);
				}else if(parent[0] == _x && parent[1] == _y){
					continue;
				}else{
					parent[0] = _x;
					parent[1] = _y;
					buffer.put(_x);
					buffer.put(_y);
				}
			}
			buffer.flip();
			
			double[] newCoordinates = new double[ buffer.limit()];
			//buffer.
			buffer.get(newCoordinates, 0, newCoordinates.length);
			
			newPoly[index] = newCoordinates;
		}
	
		
		
		//找最大最小的Y
		
		double minY = EMTPY;
		double maxY = EMTPY;
		
		for(int pathIndex = 0; pathIndex < newPoly.length; pathIndex++) { 
			double[] subPoints = newPoly[pathIndex];
	        for(int i = 0 ; i < subPoints.length/2 ; i ++){
	        	double y = subPoints[i * 2 + 1];
	        	if(minY == EMTPY){
	        		minY = y;
	        	}
	        	if(maxY == EMTPY){
	        		maxY = y;
	        	}
	        	if(y >= maxY){
	        		maxY = y;
	        	}
	        	if(y < minY){
	        		minY = y;
	        	}
	        }
	    }
		
		double scanlineY = minY;
		double gridExtendMaxY = maxY;
		
		double minX = 0;
		double maxX = (int)((this.getMaxX() - this.getMinX()) / resolution);
		HashSet scanXY = new HashSet();
		
		//开始扫描
		while(scanlineY <= gridExtendMaxY){
			//创建扫描线
			long a1 = System.currentTimeMillis();
			double[][] scanline = null;
			scanline = new double[][]{new double[]{minX,scanlineY},new double[]{maxX,scanlineY}};	
			int Y = (int)(scanlineY/ this.getBase());
			ArrayList<Double> scanlineXDoubleArray = new ArrayList<Double>();
			for(int pathIndex = 0; pathIndex < newPoly.length; pathIndex++) { 
				double[] subPoints = newPoly[pathIndex];
				if(subPoints.length <= 2){
					//只有一个点的情况
					double x = (int)(subPoints[0] / this.getBase());
					double y = (int)(subPoints[1]);
					if(y == scanlineY){
						scanlineXDoubleArray.add(x);
					}
				}else{
					//是线段面的情况
					 for(int i = 0 ; i < subPoints.length/2 - 1 ; i ++){
						double point1x = subPoints[i * 2];
						double point1y = subPoints[i * 2 + 1];
						double point2x = subPoints[i * 2 + 2];
						double point2y = subPoints[i * 2 + 3];
						// 查看该线段是否有可能与扫描线相交;
						if (point1y < scanlineY && point2y < scanlineY) {
							continue;
						}
						if (point1y > scanlineY && point2y > scanlineY) {
							continue;
						}

						double[] intersection = LINEINTERSECTS(scanline[0][0], scanline[0][1], scanline[1][0],
								scanline[1][1], point1x, point1y, point2x, point2y);
						if (intersection != null) {
							double x = (int)(intersection[0] / this.getBase());
							double y = (int)(intersection[1] / this.getBase());
							scanlineXDoubleArray.add(x);
						}
				        	
			        }
					//最后一个点
			        double point1x = subPoints[subPoints.length - 2];
		        	double point1y = subPoints[subPoints.length - 1];
		        	double point2x = subPoints[0];
		        	double point2y = subPoints[1];
		        	if (point1y < scanlineY && point2y < scanlineY) {
						continue;
					}
					if (point1y > scanlineY && point2y > scanlineY) {
						continue;
					}
		        	double[] intersection = LINEINTERSECTS(scanline[0][0], scanline[0][1], scanline[1][0], scanline[1][1], 
		        			point1x, point1y,point2x, point2y);
		        	if(intersection != null) {
		        		double x = (int)(intersection[0] / this.getBase());
						double y = (int)(intersection[1] / this.getBase());
						scanlineXDoubleArray.add(x);
		            }	        	
				}
			}
			
			/*for(int i = 0 ; i < scanlineXDoubleArray.size() ; i ++){
				int x = (int)(scanlineXDoubleArray.get(i)/1);
				
				//Integer[] extentint = new Integer[]{x,(int)(scanlineY/ this.getBase())};
				StringBuilder key = new StringBuilder().append(x).append("_").append((int)(scanlineY/ this.getBase()));
            	scanXY.add(key.toString());
			}*/
			
			
			
			Collections.sort(scanlineXDoubleArray, new Comparator<Double>() {
			    @Override
    			public int compare(Double o1, Double o2) {
    				double x1 = o1;
    				double x2 = o2;
    				if(x1 >= x2){
    					return 1;
    				}else{
    					return -1;
    				}
    				//return x1.compareTo(x2);
    			}
    		});
			
			for(int intersectionsIndex = 0; intersectionsIndex < scanlineXDoubleArray.size() - 1; intersectionsIndex++) {
	            if(intersectionsIndex % 2 == 0){
	            	double intersectionXEnter = scanlineXDoubleArray.get(intersectionsIndex );
	            	double intersectionXExit = scanlineXDoubleArray.get(intersectionsIndex + 1);
	            	
	     

	            	
	            	int enterX = (int)intersectionXEnter ;
	            	int exitX = (int)intersectionXExit ;
	            	
	               // int x = enter.getX();
	            	
	            	
	            	while (enterX <= exitX) {
	                	//Integer[] extentint = new Integer[]{enterX,(int)(scanlineY/ this.getBase())};
	                	//String key = enterX + "_" + (int)(scanlineY/ this.getBase());
	                	//scanXY.put(key, extentint);
	            		Long l = twoInt2Long(enterX,Y);
	            		
	                	//StringBuilder key = new StringBuilder().append(enterX).append("_").append((int)(scanlineY/ this.getBase()));
	                	scanXY.add(l);
	                	//scanXY.add(key.toString());
	                	enterX ++;
	                }
	            }
	        }
			
			
			scanlineY = scanlineY + 1;
			//System.out.println(scanlineY +"_" + (a2 - a1));

		}
		
		
		
		
		
		
		return  scanXY;
		
		
		
	}
	
	
	
	
	public static long twoInt2Long(int low,int high){  
		 return ((long)low & 0xFFFFFFFFL) | (((long)high << 32) & 0xFFFFFFFF00000000L);
	} 

	
	
	
	
	public static double[] LINEINTERSECTS(double line1StartX, double line1StartY, double line1EndX, double line1EndY, double line2StartX, double line2StartY, double line2EndX, double line2EndY) {
		
		double[] res = new double[]{Double.MAX_VALUE,Double.MAX_VALUE};
		
		double denominator = ((line2EndY - line2StartY) * (line1EndX - line1StartX)) - ((line2EndX - line2StartX) * (line1EndY - line1StartY));

		if (denominator == 0) {
	        if(res[0] != Double.MAX_VALUE && res[1] != Double.MAX_VALUE) {
	            return res;
	        } else {
	            return null;
	        }
	    }
		
		double a = line1StartY - line2StartY;
		double b = line1StartX - line2StartX;
		double numerator1 = ((line2EndX - line2StartX) * a) - ((line2EndY - line2StartY) * b);
		double numerator2 = ((line1EndX - line1StartX) * a) - ((line1EndY - line1StartY) * b);
	    a = numerator1 / denominator;
	    b = numerator2 / denominator;

	    
		
	    if (b >= 0 && b <= 1) {
	    	res[0] = line1StartX + (a * (line1EndX - line1StartX));
		    res[1] = line1StartY + (a * (line1EndY - line1StartY));
	        return res;
	    }
	    else {
	        return null;
	    }		
	}
	

	
	
	public static double[][] create(Geometry geom) throws Exception{
		
		
		int length = geom.getNumGeometries();
		double[][] darr = new double[length][];
		for(int i = 0 ; i < length ; i ++){
			
			Geometry sub = geom.getGeometryN(i);
			Coordinate[] cc = sub.getCoordinates();
			int cclength = cc.length;
			double[] subArr = new double[cclength * 2];
			
			for(int j = 0 ;j < cclength ; j ++){
				Coordinate c = sub.getCoordinates()[j];
				subArr[j*2] = c.x;
				subArr[j*2 + 1] = c.y;
			}
			darr[i] = subArr;
		}
		return darr;
	}
	

}