/**
　 * <p>Title: WkbEncoder.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * 
　 * 
　 * @date 2021年7月2日
　 * @version 1.0
*/
package com.northpool.spatial.wkb;


import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;


import org.locationtech.jts.io.WKBConstants;

import com.northpool.commons.bits.HexUtils;
import com.northpool.spatial.Constants.GEO_TYPE;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.spatial.geofeature.GeoPart;
import com.northpool.spatial.geofeature.GeoPart.RING_TYPE;

/**
 * 
 *
 */
public abstract class AbstractWkbEncoder{
    
  

    
    //final ByteOrder byteOrder;
    
   // final boolean bigEndian; 
    
   // protected boolean haveSrid = false;
    
   // protected boolean toHexBytes = false;
        
    protected AbstractWkbEncoder(/*ByteOrder byteOrder*/){
       /* this.byteOrder = byteOrder;
        if(this.byteOrder == ByteOrder.BIG_ENDIAN){
            this.bigEndian = true;
        }else{
            this.bigEndian = false;
        }*/
    }

    
    
    public byte[] _fromGeoBuffer(GeoBuffer geoBuffer,ByteOrder byteOrder,boolean includeSrid){
        ByteBuffer byteBuffer = this.byteBufferFromGeoBuffer(geoBuffer,byteOrder,includeSrid);
        int len = byteBuffer.limit() - byteBuffer.position();
        byte[] bytes = new byte[len];
        byteBuffer.get(bytes);
        return bytes;
    }
    
    
    public ByteBuffer byteBufferFromGeoBuffer(GeoBuffer geoBuffer,ByteOrder byteOrder,boolean includeSrid) {
        
        GEO_TYPE geotype = geoBuffer.getGeoType();
        
        int dimension = geoBuffer.getDimension();
        int size = 0;
        ByteBuffer buffer;
        GeoPart[] parts = geoBuffer.getPartList().toArray(new GeoPart[geoBuffer.getPartList().size()]);;
        GeoPart[][] polygons;
        int srid = geoBuffer.getSRID();
        switch (geotype) {
            case POINT:
                size = this.calculatePoint(size, geoBuffer.getDimension(),includeSrid);
                buffer = this.allocate(size,byteOrder);
                this.processPoint(dimension,geoBuffer.getX(),geoBuffer.getY(),geoBuffer.getZ(),byteOrder,buffer,srid,includeSrid);
                break;
            case LINESTRING:
                size = this.calculateLineString(size, geoBuffer.getDimension(),geoBuffer.getPartList().get(0),includeSrid);
                buffer = this.allocate(size,byteOrder);
                this.processLineString(dimension,byteOrder,buffer,0,geoBuffer.getPartList().get(0),srid,includeSrid);
                break;
            case POLYGON:
                size = this.calculatePolygon(size, geoBuffer.getDimension(),parts,includeSrid);
                buffer = this.allocate(size,byteOrder);
                this.processPolygon(dimension,byteOrder,buffer,0,parts,srid,includeSrid);
                break;
           /* case MULTIPOINT:
               // this.processMultiPoint(buffer, geo,hasZ);
                break;*/
            case MULTILINESTRING:
                size = this.calculateMultiLineString(size, geoBuffer.getDimension(),parts,includeSrid);
                buffer = this.allocate(size,byteOrder);
                this.processMultiLineString(dimension,byteOrder,buffer,0,parts,srid,includeSrid);
                break;
            case MULTIPOLYGON:
                polygons = this.multiPolygonChange(parts);
                size = this.calculateMultiPolygon(size, dimension, polygons,includeSrid);
                buffer = this.allocate(size,byteOrder);
                this.processMultiPolygon(dimension,byteOrder,buffer,0,polygons,srid,includeSrid);
                break;
                
            case COLLECTION:
            default:
                throw new RuntimeException("不支持的几何类型：" + geotype.name());
                
            }
        return buffer;
        
    }
    
    
    
    
    /**
     * @param dimension
     * @param byteOrder
     * @param buffer
     * @param i
     * @param polygons
     * @param srid 
     */
    private int processMultiPolygon(int dimension, ByteOrder byteOrder, ByteBuffer buffer, int offset,
        GeoPart[][] polygons, int srid,boolean includeSrid) {
        offset = this.writeByteOrder(offset,buffer, byteOrder);
        
        offset = this.writeGeometryType(offset, WKBConstants.wkbMultiPolygon, dimension, buffer,includeSrid,srid);
        
        int geoPartCount = polygons.length;
        
        offset = this.writeGeoPartCount(offset, geoPartCount,buffer);
        
        for(int i = 0 ; i < polygons.length ; i ++){
            GeoPart[] polygon = polygons[i];
            offset = this.processPolygon(dimension, byteOrder, buffer, offset, polygon, srid,false);
        }

        return offset;
    }




    /**
     * @param dimension
     * @param byteOrder
     * @param buffer
     * @param i
     * @param parts
     * @param srid 
     */
    private int processMultiLineString(int dimension, ByteOrder byteOrder, ByteBuffer buffer, int offset, GeoPart[] parts, int srid,boolean includeSrid) {
        // TODO Auto-generated method stub
        offset = this.writeByteOrder(offset,buffer, byteOrder);
        
        offset = this.writeGeometryType(offset, WKBConstants.wkbMultiLineString, dimension, buffer,includeSrid,srid);

        int geoPartCount = parts.length;
        
        offset = this.writeGeoPartCount(offset, geoPartCount,buffer);
        
        for(int i = 0 ; i < parts.length ; i ++){
            offset = this.processLineString(dimension, byteOrder, buffer, offset, parts[i], i,false);
        }
        return offset;
        
    }




    /**
     * @param dimension
     * @param byteOrder
     * @param buffer
     * @param srid 
     * @param i
     * @param partList
     */
    private int processPolygon(int dimension, ByteOrder byteOrder, ByteBuffer buffer, int offset,GeoPart[] parts, int srid,boolean includeSrid) {
        
        offset = this.writeByteOrder(offset,buffer, byteOrder);
        
        offset = this.writeGeometryType(offset, WKBConstants.wkbPolygon, dimension, buffer,includeSrid,srid);

        int geoPartCount = parts.length;
        
        offset = this.writeGeoPartCount(offset, geoPartCount,buffer);
        
        for(int i = 0 ; i < parts.length ; i ++){
            offset = this.writeCoordinateSequence(offset,parts[i],buffer,dimension);
        }
        return offset;
    }




    /**
     * @param offset
     * @param geoPartCount
     * @param buffer
     * @return
     */
    private int writeGeoPartCount(int offset, int geoPartCount, ByteBuffer buffer) {
        // TODO Auto-generated method stub
        buffer.putInt(offset,geoPartCount);
        offset += 4;
        return offset;
    }




    
    
    
    
    
    /**
     * @param size
     * @param dimension
     * @param multiPolygonGeoPart
     * @return
     */
    private int calculateMultiPolygon(int size, int dimension, GeoPart[][] multiPolygonGeoPart,boolean includeSrid) {
        size = (1 /*ByteOrder*/) + (4 /* type */) + (includeSrid ? 4 : 0)/* srid */ + (4 /* Polygon个数  */) ;
        for(int i = 0 ; i < multiPolygonGeoPart.length ; i ++){
            GeoPart[] part = multiPolygonGeoPart[i];
            size = this.calculatePolygon(size, dimension, part,false);
        }
        return size;
    }




    /**
     * @param size
     * @param dimension
     * @param parts
     * @return
     */
    private GeoPart[][] multiPolygonChange(GeoPart[] parts) {
        ArrayList<GeoPart[]> partPolygon = new ArrayList<GeoPart[]>();
        int polygonSzie = 0;
        ArrayList<GeoPart> polygon = new ArrayList<>();
        for(int i = 0 ; i < parts.length ; i ++){
            GeoPart part = parts[i];
            if(part.getRingType() == RING_TYPE.outside){
                if(polygonSzie != 0){
                    partPolygon.add(polygon.toArray(new GeoPart[polygon.size()]));
                    polygon = new ArrayList<>();
                }
                polygonSzie ++;
            }
            polygon.add(part);
        }
        partPolygon.add(polygon.toArray(new GeoPart[polygon.size()]));
        
        return partPolygon.toArray(new GeoPart[partPolygon.size()][]);
    }




    /**
     * @param size
     * @param dimension
     * @param parts
     */
    private int calculateMultiLineString(int size, int dimension, GeoPart[] parts,boolean includeSrid) {
        size = size + (1 /*ByteOrder*/) + (4 /* type */) + (includeSrid == true ? 4 : 0)/* srid */ + (4 /* 坐标串个数  */);
        for(int i = 0 ; i < parts.length ; i ++){
            GeoPart part = parts[i];
            size = this.calculateLineString(size, dimension, part, false);
         //   partSize = partSize + (part.getCoordinateCount() /* 坐标个数 */) + (dimension * 8 /* xyz coordinate */);
        }
        return size;
    }




    /**
     * @param size
     * @param dimension
     * @param parts
     * @return
     */
    private int calculatePolygon(int size, int dimension, GeoPart[] parts,boolean includeSrid) {
        // TODO Auto-generated method stub
        
        size = size + (1 /*ByteOrder*/) + (4 /* type */) + ( includeSrid == true ? 4 : 0)/* srid */ + (4 /* 坐标串个数  */) ;//+  (dimension * 8 /* xyz coordinate */);
        
        for(int i = 0 ; i < parts.length ; i ++){
            GeoPart part = parts[i];
            size =  this.calculateCoordinateSequence( size, dimension, part);
           // size = size + (part.getCoordinateCount() /* 坐标个数 */) * (dimension * 8 /* xyz coordinate */);
        }
        return size;
    }


    

    /**
     * @param size
     * @param dimension
     * @param part
     * @return
     */
    private int calculateCoordinateSequence(int size, int dimension, GeoPart part) {
        size = size + 4; // 坐标个数;
        size = size + part.getCoordinateCount() * (dimension * 8); // 坐标信息;
        return size;
    }




    /**
     * @param size
     * @param dimension
     * @return
     */
    private int calculateLineString(int size, int dimension,GeoPart part,boolean includeSrid) {
        // TODO Auto-generated method stub
        size = (1 /*ByteOrder*/) + (4 /* type */) + ( includeSrid ? 4 : 0)/* srid */ + this.calculateCoordinateSequence(size, dimension, part);
        
        return size;
    }




    /**
     * @param size
     * @param includeSRID
     * @param dimension
     * @return
     */
    private int calculatePoint(int size, int dimension,boolean includeSrid) {
        // TODO Auto-generated method stub
        size = size + (1 /*ByteOrder*/) + (4 /* type */) + ( includeSrid == true ? 4 : 0)/* srid */ + (dimension * 8 /* xy coordinate */);
        return size;
    }




   
    
    

    private ByteBuffer allocate(int size,ByteOrder byteOrder){
        
        /*if(toHexBytes){
            size = size * 2;
        }*/
        
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.order(byteOrder);
        return buffer;
    }
    
    void put(int offset, ByteBuffer buffer,byte b){
       /* if(toHexBytes){
            HexUtils.putHexByte(offset, buffer, b);
        }else{*/
            buffer.put(offset, b);
       // }
        
    }
    
    void putInt(int offset, ByteBuffer buffer,int i){
        
            
       /* if(toHexBytes){
            HexUtils.putIntHexByte(offset, buffer, i, bigEndian);
        }else{*/
            buffer.putInt(offset, i);
       // }
        
    }
    
    void putDouble(int offset, ByteBuffer buffer,double d){
       /* if(toHexBytes){
            HexUtils.putDoubleHexByte(offset, buffer, d, bigEndian);
        }else{*/
            buffer.putDouble(offset, d);
       // }
    }
    
    
    
    
    
    int writeByteOrder(int offset, ByteBuffer buffer, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            //buffer.put(offset, (byte)WKBConstants.wkbNDR);
            this.put(offset, buffer, (byte)WKBConstants.wkbNDR);
        } else {
            this.put(offset, buffer, (byte)WKBConstants.wkbXDR);
          //  buffer.put(offset, (byte)WKBConstants.wkbXDR);
        }
        offset = offset + 1;
        return offset;
    }
    
    int writeGeometryType(int offset, int geometryType, int dimension, ByteBuffer buffer,boolean includeSrid,int srid) {
        int flag3D = (dimension == 3) ? 0x80000000 : 0;
        int flagSRID = includeSrid == true ? 0x20000000 : 0;
        int typeInt = geometryType | flag3D | flagSRID;
       // buffer.putInt(offset, typeInt);
        this.putInt(offset, buffer, typeInt);
        offset = offset + 4;
       
        if( includeSrid){
            offset = this.writeSRID(offset,buffer,srid);
        }
        
        return offset;
    }
    
    /**
     * 转换point
     * @param geoBuffer
     * @param byteOrder
     * @param srid 
     * @return
     */
    void processPoint(int dimension, double x, double y, double z,ByteOrder byteOrder,ByteBuffer buffer, int srid,boolean includeSrid){
           
        int offset = 0;
        
        offset = this.writeByteOrder(offset,buffer, byteOrder);
      
        offset = this.writeGeometryType(offset, WKBConstants.wkbPoint, dimension, buffer,includeSrid,srid);
        
        

        //buffer.putDouble(offset,x);
        this.putDouble(offset, buffer, x);
        offset += 8;
        this.putDouble(offset, buffer, y);
        //buffer.putDouble(offset,y);
        offset += 8;
       
        if (dimension == 3) {
            //buffer.putDouble(offset,z);
            this.putDouble(offset, buffer, z);
            offset += 8;
        }
        
    }
    
    /**
     * @param offset
     * @param buffer
     * @param srid
     * @return
     */
    private int writeSRID(int offset, ByteBuffer buffer, int srid) {
        // TODO Auto-generated method stub
        this.putInt(offset, buffer, srid);
        offset += 4;
        return offset;
    }

    int processLineString(int dimension, ByteOrder byteOrder,ByteBuffer buffer,int offset,GeoPart part, int srid,boolean includeSrid) {
       
        offset = this.writeByteOrder(offset,buffer, byteOrder);
      
        offset = this.writeGeometryType(offset, WKBConstants.wkbLineString, dimension, buffer,includeSrid,srid);

        offset = this.writeCoordinateSequence(offset,part,buffer,dimension);
        
        return offset;
        
    }
    
    /**
     * @param offset
     * @param part
     * @param buffer
     * @param bExportZ 
     * @return
     */
    private int writeCoordinateSequence(int offset, GeoPart part, ByteBuffer buffer, int dimension) {
        int coordinateCount = part.getCoordinateCount();
        offset = this.writeCoordinateCount(offset,coordinateCount,buffer);
        for(int i = 0 ; i < coordinateCount ; i ++){
            int index = i * dimension;
            this.putDouble(offset, buffer, part.getDoubleBuilder().get(index));
          //  buffer.putDouble(offset,part.getDoubleBuilder().get(index));//x
            offset += 8;
            this.putDouble(offset, buffer, part.getDoubleBuilder().get(index + 1));
           // buffer.putDouble(offset,part.getDoubleBuilder().get(index + 1));//y
            offset += 8;
            if(dimension == 3){
                this.putDouble(offset, buffer, part.getDoubleBuilder().get(index + 2));
                //buffer.putDouble(offset,part.getDoubleBuilder().get(index + 2));//z
                offset += 8;
            }   
        }
        return offset;
    }




    /**
     * @param offset
     * @param coordinateCount
     * @param buffer
     * @return
     */
    private int writeCoordinateCount(int offset, int coordinateCount, ByteBuffer buffer) {
        this.putInt(offset, buffer, coordinateCount);
        //buffer.putInt(offset,coordinateCount);
        offset += 4;
        return offset;
    }




    public static void main(String[] aaa){
       // WKBWriter
        
    }
    
    

}
