///**
//　 * <p>Title: WkbConverter.java</p>
//　 * <p>Description: </p>
//　 * <p>Copyright: Copyright (c) 2019</p>
//　 * 
//　 * 
//　 * @date 2021年3月29日
//　 * @version 1.0
//*/
//package com.northpool.spatial.wkb;
//
//import java.io.IOException;
//import java.io.ByteArrayInputStream;
//
//import org.locationtech.jts.io.ByteOrderValues;
//import org.locationtech.jts.io.WKBConstants;
//
//
//import com.northpool.spatial.ByteOrderDataInStream;
//import com.northpool.spatial.GeomBuilder;
//import com.northpool.spatial.GeomConverter;
//import com.northpool.spatial.GeometryInfo;
//import com.northpool.spatial.Constants.GEO_TYPE;
//
//
///**
// * 
// * 
// *
// */
//public class WkbConverter implements GeomConverter<ByteArrayInputStream> {
//
//    
//    public static final int UNKNOWN = 0;
//    public static final int POINT = 1;
//    public static final int LINESTRING = 2;
//    public static final int POLYGON = 3;
//    public static final int MULTIPOINT = 4;
//    public static final int MULTILINESTRING = 5;
//    public static final int MULTIPOLYGON = 6;
//    public static final int COLLECTION = 7;
//        
//    
//    protected static WkbDecoder _decoder = new WkbDecoder();
//    
//    public static WkbDecoder decoder(){
//        return _decoder;
//    }
//    
//    public int getSRID(ByteOrderDataInStream dis) throws IOException{
//        byte[] sridByte = dis.readByte4();
//        int srid = 0;
//        srid = sridByte[3] << 24 | (sridByte[2] & 0xFF) << 16 | (sridByte[1] & 0xFF) << 8 | sridByte[0] & 0xFF;
//        return srid;
//    }
//    
//    public ByteOrderDataInStream getStruct(ByteArrayInputStream instream){
//        ByteOrderDataInStream dis = new ByteOrderDataInStream(instream);
//        return dis;
//    }
//    
//    public void setByteOrder(ByteOrderDataInStream dis) throws IOException{
//        byte byteOrderWKB = dis.readByte();
//        // always set byte order, since it may change from geometry to geometry
//        int byteOrder = byteOrderWKB == WKBConstants.wkbNDR ? ByteOrderValues.LITTLE_ENDIAN : ByteOrderValues.BIG_ENDIAN;
//        dis.setOrder(byteOrder);
//    }
//    
//    
//    public GeometryInfo buildGeometryTypeAndZM(ByteOrderDataInStream dis) throws IOException{
//        int typeInt = dis.readInt();
//        GeometryInfo info = new GeometryInfo();
//        info.geometryType = typeInt & 0xff;
//        // determine if Z values are present
//        info.hasZ = (typeInt & 0x80000000) != 0;
//        info.hasM = (typeInt & 0x40000000) != 0;
//        return info;
//       
//    }
//    
//    public void check(ByteArrayInputStream instream) throws Exception{
//        if (null == instream || instream.available() <= 0){
//            throw new Exception("流不能为空");
//        }
//    }
//    
//    public int getSize(ByteArrayInputStream instream){
//        return instream.available();
//    }
//    
//    
//
//    @Override
//    public <TO> TO converter(GeomBuilder<TO> builder,ByteArrayInputStream instream) throws Exception{
//        if (null == instream || instream.available() <= 0){
//            throw new Exception("流不能为空");
//        }
//        
//        ByteOrderDataInStream dis = new ByteOrderDataInStream(instream);
//        
//        
//        byte[] sridByte = dis.readByte4();
//        int srid = 0;
//        srid = sridByte[3] << 24 | (sridByte[2] & 0xFF) << 16 | (sridByte[1] & 0xFF) << 8 | sridByte[0] & 0xFF;
//        
//        byte byteOrderWKB = dis.readByte();
//        // always set byte order, since it may change from geometry to geometry
//        int byteOrder = byteOrderWKB == WKBConstants.wkbNDR ? ByteOrderValues.LITTLE_ENDIAN : ByteOrderValues.BIG_ENDIAN;
//        dis.setOrder(byteOrder);
//        
//        int typeInt = dis.readInt();
//        GeometryInfo info = new GeometryInfo();
//        info.geometryType = typeInt & 0xff;
//        // determine if Z values are present
//        info.hasZ = (typeInt & 0x80000000) != 0;
//        info.hasM = (typeInt & 0x40000000) != 0;
//                
//        GEO_TYPE geoType = is(info.geometryType);
//        
//        int inputDimension =  info.hasZ ? 3 : 2;
//        
//        TO to = builder.newInstance(geoType,srid,inputDimension);
//        
//        return this.process(geoType, dis,builder, to, info);
//
//    }
//    
//    
//    protected <TO> TO process(GEO_TYPE geoType,ByteOrderDataInStream dis,GeomBuilder<TO> builder,TO to,GeometryInfo info) throws IOException{
//        switch (geoType) {
//        case POINT:
//            this.processPoint(dis,builder,to,info);
//            break;
//        case LINESTRING:
//            this.processLineString(dis, builder,to,info);
//            break;
//        case POLYGON:
//            this.processPolygon(dis, builder,to,info);
//            break;
//            
//        case MULTIPOINT:
//            this.processMultiPoint(dis, builder,to,info);
//            break;
//        case MULTILINESTRING:
//            this.processMultiLine(dis, builder,to,info);
//            break;
//        case MULTIPOLYGON:
//            this.processMultiPolygon(dis, builder,to,info);
//            break;
//            
//        case COLLECTION:
//        default:
//            throw new RuntimeException("不支持的几何类型：" + geoType.name());
//            
//        }
//        return to;
//    }
//    
//    
//    
//    public GEO_TYPE is(int type) {
//        switch (type) {
//            case POINT:
//                return GEO_TYPE.POINT;
//            case LINESTRING:
//                return GEO_TYPE.LINESTRING;
//            case POLYGON:
//                return GEO_TYPE.POLYGON;
//            case COLLECTION:
//                return GEO_TYPE.COLLECTION;
//            case MULTIPOINT:
//                return GEO_TYPE.MULTIPOINT;
//            case MULTILINESTRING:
//                return GEO_TYPE.MULTILINESTRING;
//            case MULTIPOLYGON:
//                return GEO_TYPE.MULTIPOLYGON;
//            }
//        throw new RuntimeException("未知的数据类型" + type);
//    }
//    
//    
//    private <TO> void processMultiPolygon(ByteOrderDataInStream dis,GeomBuilder<TO> builder,TO to,GeometryInfo info) throws IOException {
//        // 解析几何结构
//        int nParts = dis.readInt();
//        builder.setMultiPartSize(nParts);
//        for (int i = 0; i < nParts; i++) {
//            dis.readByte();
//            dis.readInt();
//            this.processPolygon(dis, builder,to,info);
//        }
//    }
//    
//    
//    // 多part-线处理
//    private <TO> void processMultiLine(ByteOrderDataInStream dis,GeomBuilder<TO> builder,TO to,GeometryInfo info) throws IOException {
//        // 解析几何结构
//        int nParts = dis.readInt();
//        builder.setMultiPartSize(nParts);
//        for (int i = 0; i < nParts; i++) {
//            dis.readByte();
//            dis.readInt();
//            this.readPointArray(dis,builder,to,info); //points
//        }
//    }
//    
//    
//    // 多part-点处理
//    private <TO> void processMultiPoint(ByteOrderDataInStream dis,GeomBuilder<TO> builder,TO to,GeometryInfo info) throws IOException {
//        // 解析几何结构
//        int nParts = dis.readInt();
//        builder.setMultiPartSize(nParts);
//        for (int i = 0; i < nParts; i++) {
//            dis.readByte();
//            dis.readInt();
//
//            this.processPoint(dis, builder,to,info);
//            
//            //this.processMunltiObjectNextPart(grids);
//                
//        }// for part
//    }
//    
//    
//    // 多边形处理
//    private <TO> void processPolygon(ByteOrderDataInStream dis,GeomBuilder<TO> builder,TO to,GeometryInfo info) throws IOException {
//        // 解析几何结构
//        int nParts = dis.readInt();
//        builder.setPolygonPartSize(nParts);
//        for (int i = 0; i < nParts; i++) {
//            this.readPointArray(dis,builder,to,info);
//        }
//    }
//    
//    
//    
//
//    
//    private <TO> void processLineString(ByteOrderDataInStream dis,GeomBuilder<TO> builder,TO to,GeometryInfo info) throws IOException {
//        // 解析几何结构
//        //DoubleBuilder doubleBuilder = null;
//        this.readPointArray(dis,builder,to,info);
//       
//        
//       // geo.addLinePart(doubleBuilder, bbox[0], bbox[1], bbox[2], bbox[3]);
//        
//    }
//    
//    
//    // 点处理
//    private <TO> void processPoint(ByteOrderDataInStream dis,GeomBuilder<TO> builder,TO to,GeometryInfo info) throws IOException {
//        
//
//        // 解析几何结构
//        double x = dis.readDouble();
//        double y = dis.readDouble();
//        builder.setX(x,to);
//        builder.setY(y,to);
//        
//        //builder.append(x);
//        //builder.append(y);
//        
//        if(info.hasZ()){
//            double z = dis.readDouble();
//            builder.setZ(z,to);
//        }
//        if(info.hasM()){
//            dis.readDouble();
//        }
//        info.setBbox(x,x,y,y);
//        //geo.addPointPart(builder);
//        //this.processPoint(x, y, screenExtentArray);
//
//    }
//    
//    
//     
//    private <TO> void readPointArray(ByteOrderDataInStream dis,GeomBuilder<TO> builder,TO to,GeometryInfo info) throws IOException {
//        int count = dis.readInt();
//        builder.setPartCoordinatesSize(count);
//        double minX = 0d;
//        double minY = 0d;
//        double maxX = 0d;
//        double maxY = 0d;
//        for (int i = 0; i < count; i++) {
//            double x = dis.readDouble();
//            double y = dis.readDouble();
//            if(x > maxX){
//                maxX = x;
//            }
//            if(x < minX){
//                minX = x;
//            }
//            if(y > maxY){
//                maxY = y;
//            }
//            if(y < minY){
//                minY = y;
//            }
//            builder.setX(x, to);
//            builder.setY(y, to);
//            if(info.hasZ()){
//                double z = dis.readDouble();
//                builder.setZ(z, to);
//            }
//            if(info.hasM()){
//                @SuppressWarnings("unused")
//                double m = dis.readDouble();
//            }
//        }
//        //doubleBuilder.trimToSize();
//        info.setBbox(minX,minY,maxX,maxY);
//    }
//
//
//}
