/**
　 * <p>Title: WkbEnCoder.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * 
　 * 
　 * @date 2021年7月2日
　 * @version 1.0
*/
package com.northpool.spatial.wkt;

import java.nio.ByteOrder;

import com.northpool.spatial.AGeomEncoder;
import com.northpool.spatial.GeomEncoder;
import com.northpool.spatial.Constants.SPATIAL_TYPE;
import com.northpool.spatial.geofeature.GeoBuffer;

/**
 * 
 * 先暂时这样写
 */
@AGeomEncoder(type = SPATIAL_TYPE.wkt)
public class WktEncoder implements GeomEncoder<String> {

    public static final WktEncoder ENCODER = new WktEncoder();
    
    @Override
    public String fromGeoBuffer(GeoBuffer geoBuffer) {
       
        return this.fromGeoBuffer(geoBuffer, true, ByteOrder.LITTLE_ENDIAN);
    }

    
    @Override
    public String fromGeoBuffer(GeoBuffer geoBuffer, boolean includeSrid, ByteOrder byteOrder) {

        String wkt = geoBuffer.toJTSGeometry().toString();
        if(includeSrid){
            int srid = geoBuffer.getSRID();
            if(srid == 0){
                return wkt;
            }
            return new StringBuilder("SRID=").append(srid).append(";").append(wkt).toString();
        }else{
            return wkt;
        }
        
    }

}
