package com.northpool.type;



import java.math.BigDecimal;

import com.northpool.exception.NotSupport;
import com.northpool.type.Types.TYPE_ENUM;

public class TypeBoolean extends AbstractType implements Type {

   
    public static final TypeBoolean INSTANCE = new TypeBoolean();
    
    public TypeBoolean() {
        super(TYPE_ENUM.Boolean);
    }


    @Override
    public String name() {
        return Types.TYPE_ENUM.Boolean.name();
    }

   
    @Override
    public Class<?> getJavaClass() {
        return Boolean.class;
    }

   
    @Override
    public boolean isType(Object o) {
        if(o == null){
            return false;
        }
        return o instanceof Boolean;
    }

    @Override
    public Object strToType(String str) {
        if(this.stringNull(str)){
            return null;
        }
        if("1".equals(str)){
            return true;
        }
        if("0".equals(str)){
            return false;
        }
        return Boolean.valueOf(str);
    }

  
    @Override
    public String valueToString(Object o) {
        this.testType(this,o);
        if(o == null){
            return "";
        }else{
            return o.toString();
        }
    }

   
    @Override
    public Object toType(Object o) {
        if(o == null){
            return null;
        }
        // TODO Auto-generated method stub
        if(this.isType(o)){
            return o;
        }else{
            return this.strToType(o.toString());
        }
    }
    
    Object booleanToNumber(Type type,Object o){
        boolean bValue = (boolean)this.toType(o);
        if(type.getEnum() == TYPE_ENUM.Integer){
            if(bValue){
                return (int)1;
            }else{
                return (int)0;
            }
        }
        if(type.getEnum() == TYPE_ENUM.Short){
            if(bValue){
                return (short)1;
            }else{
                return (short)0;
            }
        }
        if(type.getEnum() == TYPE_ENUM.Double){
            if(bValue){
                return (double)1;
            }else{
                return (double)0;
            }
        }
        if(type.getEnum() == TYPE_ENUM.Float){
            if(bValue){
                return (float)1;
            }else{
                return (float)0;
            }
        }
        if(type.getEnum() == TYPE_ENUM.Long){
            if(bValue){
                return (long)1;
            }else{
                return (long)0;
            }
        }
        if(type.getEnum() == TYPE_ENUM.BigDecimal){
            if(bValue){
                return new BigDecimal(1);
            }else{
                return new BigDecimal(0);
            }
        }
        return null;
        
    }


    
    @Override
    public Boolean isTypePrimitive(Object o) {
        return o.getClass().equals(boolean.class);
    }


    
    @Override
    Object nativeChange(Object o) {
        return (boolean)o;
    }

    
    

    
    @Override
    Object numberChange(Number o) {
        throw new NotSupport();
    }


  
}
