/**
　 * <p>Title: TypeLong.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * 
　 * 
　 * @date 2021年6月18日
　 * @version 1.0
*/
package com.northpool.type;

import com.northpool.type.Types.TYPE_ENUM;

/**
 * 
 *
 */
public class TypeLong  extends AbstractType implements Type {

    public static final TypeLong INSTANCE = new TypeLong();
    
    /**
     * @param typeEnum
     */
    public TypeLong() {
        super(TYPE_ENUM.Long);
    }

   
    
    public Class<?> getJavaClass() {
        return Long.class;
    }

    
    @Override
    public boolean isType(Object o) {
        if(o == null){
            return false;
        }
        return o instanceof Long;
    }

   
    @Override
    public Object strToType(String str) {
        if(this.stringNull(str)){
            return null;
        }
        str = parseNumberE(str);
        return new Long(str).longValue();
    }

   
    @Override
    public String valueToString(Object o) {
        if(o == null){
            return null;
        }
        this.testType(this,o);
        return parseNumberE(o.toString());
    }

    
    @Override
    public Object toType(Object o) {
        return numberToType(o);
    }

    
    @Override
    public Boolean isTypePrimitive(Object o) {
        return o.getClass().equals(long.class);
    }

   
    @Override
    Object nativeChange(Object o) {
        return (long)o;
    }

   
    @Override
    Object numberChange(Number o) {
        return o.longValue();
    }

}
