/**
　 * <p>Title: TypeShort.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * 
　 * 
　 * @date 2021年6月18日
　 * @version 1.0
*/
package com.northpool.type;

import com.northpool.type.Types.TYPE_ENUM;

/**
 * 
 *
 */
public class TypeShort extends AbstractType implements Type {

    public TypeShort() {
        super(TYPE_ENUM.Short);
    }

    public static final TypeShort INSTANCE = new TypeShort();

   
    @Override
    public Class<?> getJavaClass() {
        return Short.class;
    }

    @Override
    public boolean isType(Object o) {
        if(o == null){
            return false;
        }
        return o instanceof Short;
    }

    
    @Override
    public Object strToType(String str) {
        if(this.stringNull(str)){
            return null;
        }
        return new Short(str).shortValue();
    }

    @Override
    public String valueToString(Object o) {
        if(o == null){
            return null;
        }
        this.testType(this,o);
        return o.toString();
        
    }
    
    
    
    
   
    @Override
    public Object toType(Object o) {
        return numberToType(o);
    }

    
    @Override
    public Boolean isTypePrimitive(Object o) {
        return o.getClass().equals(short.class);
    }

   
    @Override
    Object nativeChange(Object o) {
        return (short)o;
    }

  
    @Override
    Object numberChange(Number o) {
        return o.shortValue();
    }
    
    
    
}
