/**
　 * <p>Title: Types.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * 
　 * 
　 * @date 2021年6月18日
　 * @version 1.0
*/
package com.northpool.type;

import java.util.Optional;

/**
 * 
 *
 */
public interface Types {
    
    
    public static final TypeVoid VOID = TypeVoid.INSTANCE;
    
    public static final TypeUnknown UNKNOWN = TypeUnknown.INSTANCE;
    
    public static final TypeTimestamp TIME_STAMP = TypeTimestamp.INSTANCE;
    
    public static final TypeString STRING = TypeString.INSTANCE;
    
    public static final TypeLong LONG = TypeLong.INSTANCE;
    
    public static final TypeInteger INTEGER = TypeInteger.INSTANCE;
    
    public static final TypeDouble DOUBLE = TypeDouble.INSTANCE;
    
    public static final TypeBigDecimal BIGDECIMAL = TypeBigDecimal.INSTANCE;
    
    public static final TypeBoolean BOOLEAN = TypeBoolean.INSTANCE;
    
    public static final TypeBytes BYTES = TypeBytes.INSTANCE;

    public static final Type ANY = TypeAny.INSTANCE;
    
    
    
    enum TYPE_ENUM{
        Integer,Timestamp,Short,Long,Float,Double,Bytes,String,Boolean,Void,Geometry,BigDecimal,Unknown,Any,VOID,Enum
    }
    
    public static Type isNumber(Object o){
        Type type = Types.getType(o);
        if(type.typeIsNumber()){
            return type;
        }else{
            return null;
        }
    }
    /**
     * 根据对象获得type
     * @param o
     * @return
     */
    public static Type getType(Object o){
        if(o == null){
            return null;
        }
        Type type = TypeManager.GET_TYPE.getType(o);
        if(type == null){
            throw new RuntimeException(o.toString() + ",类型" + o.getClass().getName() + " 不支持");
        }else{
            return type;
        }
    }
    /**
     * 根据class获得type
     * @param clazz
     * @return
     */
    public static Type getTypeByClass(Class<?> clazz){
        
        Type type = TypeManager.classTypeMap.get(clazz);
        if(type == null){
            throw new TypeNotFindException(clazz);
        }
        return type;
    }
    
    public static Type getTypeByName(String typeName){
        Optional<Type> optional = TypeManager.typeSet.stream().filter( type ->{
            if(type.getEnum().name().equalsIgnoreCase(typeName)){
                return true;
            }
            return false;
        }).findFirst();
        if(optional.isPresent()){
            return optional.get();
        }else{
            return null;
        }
        
    }
    
    public static Class<?> getPrimitiveType(Class<?> wraperClass){
        return TypeManager.getPrimitiveType(wraperClass);
    }
    
    public static Class<?> getWraper(Class<?> wraperClass){
        return TypeManager.getWraper(wraperClass);
    }
    
    public static boolean isWraper(Class<?> wraperClass){
        return TypeManager.isWraper(wraperClass);
    }
    
    
    public static Object convert(Object value,Class<?> clazz){
        Type type = Types.getTypeByClass(clazz);
        return type.toType(value);
    }
    
    
    public static String valueToString(Object o){
        if(o == null){
            return null;
        }else{
            Type type = getType(o);
            return type.valueToString(o);
        }
    }
    
    
  
}
