/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.commons.util;

import com.northpool.commons.util.AbstractBuilder;
import com.northpool.commons.util.DoubleBuilder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import sun.nio.ch.DirectBuffer;

public abstract class AbstractDoubleBuilder
extends AbstractBuilder
implements DoubleBuilder {
    protected final int beginSize = 2048;
    protected int expansionHeapTimes = 1;
    private final int directApplySize = 0x100000;
    protected double[] heap;
    protected int capacity;
    protected int size;
    private Boolean isDirect = false;
    protected final int typeSize = 8;
    protected final int directApplySizeNum = 0x100000 / this.typeSize;
    protected ArrayList<ByteBuffer> directBufferArr;
    protected ByteBuffer currentDirectByteBuffer = null;

    public abstract ByteOrder order();

    public AbstractDoubleBuilder() {
        this.capacity = this.beginSize / this.typeSize;
        this.heap = new double[this.capacity];
    }

    public AbstractDoubleBuilder(double[] arr) {
        this();
        this.append(arr);
    }

    public AbstractDoubleBuilder(int size) {
        this.capacity = size;
        if (this.directApplySizeNum > size) {
            this.heap = new double[size];
        } else {
            this.isDirect = true;
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(size * 8);
            this.directBufferArr = new ArrayList(1);
            this.directBufferArr.add(newBuffer);
            this.currentDirectByteBuffer = newBuffer;
        }
    }

    private void clean(ByteBuffer byteBuffer) {
        if (byteBuffer.isDirect()) {
            DirectBuffer db = (DirectBuffer)((Object)byteBuffer);
            db.cleaner().clean();
        }
    }

    @Override
    public Boolean isDirect() {
        return this.isDirect;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void expansionInHeap(int arrSize) {
        int applySize = this.beginSize * this.expansionHeapTimes / this.typeSize;
        ++this.expansionHeapTimes;
        int newSize = applySize > arrSize ? this.capacity + applySize : arrSize + arrSize % applySize + this.capacity;
        double[] newHeap = new double[newSize];
        System.arraycopy(this.heap, 0, newHeap, 0, this.size);
        this.heap = newHeap;
        this.capacity = newSize;
    }

    private void expansionInDirect(int size) {
        if (size > this.directApplySizeNum) {
            int times = size / this.directApplySizeNum + 1;
            int newCapacity = this.directApplySizeNum * times;
            while (times-- > 0) {
                ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.directApplySize);
                this.directBufferArr.add(newBuffer);
            }
            this.capacity = newCapacity;
        } else {
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.directApplySize);
            this.directBufferArr.add(newBuffer);
            this.currentDirectByteBuffer = newBuffer;
            this.capacity += this.directApplySizeNum;
        }
    }

    protected ByteBuffer getByteBuffer(int index) {
        return this.directBufferArr.get(index /= this.directApplySize);
    }

    private void toDirect(int size) {
        this.isDirect = true;
        int newSize = this.directApplySize;
        this.directBufferArr = new ArrayList();
        if ((size + this.capacity) * this.typeSize > this.directApplySize) {
            int times = (size + this.capacity) * this.typeSize / this.directApplySize + 1;
            int copyDone = 0;
            int newCapacity = this.directApplySize / this.typeSize * times;
            while (times-- > 0) {
                ByteBuffer b = ByteBuffer.allocateDirect(this.directApplySize);
                this.directBufferArr.add(b);
                int directByteBufferSize = this.directApplySize / this.typeSize;
                if (copyDone < this.size) {
                    if (this.size > directByteBufferSize) {
                        this.putArrIntoDirectByteBuffer(b, this.heap, copyDone, directByteBufferSize);
                    } else {
                        if (this.heap.length - copyDone != 0) {
                            this.putArrIntoDirectByteBuffer(b, this.heap, copyDone, this.size - copyDone);
                        }
                        this.currentDirectByteBuffer = b;
                    }
                }
                copyDone += directByteBufferSize;
            }
            this.capacity = newCapacity;
        } else {
            this.capacity = this.directApplySize / this.typeSize;
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.directApplySize);
            this.directBufferArr.add(newBuffer);
            this.currentDirectByteBuffer = newBuffer;
            this.capacity = newSize / this.typeSize;
            this.putArrIntoDirectByteBuffer(newBuffer, this.heap, 0, this.size);
        }
    }

    protected abstract void putArrIntoDirectByteBuffer(ByteBuffer var1, Object var2, int var3, int var4);

    @Override
    public void trimToSize() {
        if (!this.isDirect.booleanValue()) {
            double[] newHeap = new double[this.size];
            System.arraycopy(this.heap, 0, newHeap, 0, this.size);
            this.heap = newHeap;
        } else {
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.currentDirectByteBuffer.position());
            this.currentDirectByteBuffer.flip();
            newBuffer.put(this.currentDirectByteBuffer);
            DirectBuffer db = (DirectBuffer)((Object)this.currentDirectByteBuffer);
            db.cleaner().clean();
            this.directBufferArr.set(this.directBufferArr.size() - 1, newBuffer);
            this.currentDirectByteBuffer = newBuffer;
        }
    }

    @Override
    public double get(int index) {
        if (this.isDirect.booleanValue()) {
            index *= this.typeSize;
            if (this.directBufferArr.size() == 1) {
                int dataBlockIndex = 0;
                int dbbIndex = index;
                return this.directBufferArr.get(dataBlockIndex).getDouble(dbbIndex);
            }
            int dataBlockIndex = index / this.directApplySize;
            int dbbIndex = index % this.directApplySize;
            return this.directBufferArr.get(dataBlockIndex).getDouble(dbbIndex);
        }
        return this.heap[index];
    }

    @Override
    public DoubleBuilder append(double d) {
        int off = 1;
        if (this.size + off > this.capacity) {
            this.ensureCapacityInternal(1);
        }
        if (this.isDirect.booleanValue()) {
            this.currentDirectByteBuffer.putDouble(d);
        } else {
            this.heap[this.size] = d;
        }
        ++this.size;
        return this;
    }

    @Override
    public void set(int index, double d) {
        if (index >= this.size) {
            throw new RuntimeException("out of range");
        }
        if (this.isDirect.booleanValue()) {
            int dataBlockIndex = (index *= this.typeSize) / this.directApplySize;
            int dbbIndex = index % this.directApplySize;
            this.directBufferArr.get(dataBlockIndex).putDouble(dbbIndex, d);
        } else {
            this.heap[index] = d;
        }
    }

    @Override
    public void destroy() {
    }

    private void ensureCapacityInternal(int size) {
        if (!this.isDirect.booleanValue()) {
            if ((this.capacity + size) * this.typeSize + this.beginSize * this.expansionHeapTimes > this.directApplySize) {
                this.toDirect(size);
            } else {
                this.expansionInHeap(size);
            }
        } else {
            this.expansionInDirect(size);
        }
    }

    @Override
    public DoubleBuilder append(double[] arr) {
        this.append(arr, 0, arr.length);
        return this;
    }

    @Override
    public DoubleBuilder append(double[] arr, int offset, int length) {
        if (arr == null) {
            return this;
        }
        if (this.capacity <= length - offset + this.size) {
            this.ensureCapacityInternal(length - offset);
        }
        if (this.isDirect.booleanValue()) {
            int beginBlockIndex = this.size / this.directApplySizeNum;
            int beginSubIndex = this.size % this.directApplySizeNum;
            int endBlockIndex = (length - offset + this.size) / this.directApplySizeNum + 1;
            int copyDone = 0;
            for (int i = beginBlockIndex; i < endBlockIndex; ++i) {
                int copyLength = this.directApplySizeNum;
                ByteBuffer dbb = null;
                try {
                    dbb = this.directBufferArr.get(i);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (i == beginBlockIndex) {
                    copyLength = this.directApplySizeNum - beginSubIndex;
                }
                if (i == endBlockIndex - 1) {
                    copyLength = length - offset - copyDone;
                }
                this.putArrIntoDirectByteBuffer(dbb, arr, copyDone, copyLength);
                copyDone += copyLength;
            }
        } else {
            System.arraycopy(arr, offset, this.heap, this.size, length - offset);
        }
        this.size = this.size + length - offset;
        return this;
    }

    public DoubleBuilder delete(int start, int end) {
        throw new RuntimeException("\u6ca1\u6709\u5b9e\u73b0");
    }

    public DoubleBuilder deleteAt(int index) {
        throw new RuntimeException("\u6ca1\u6709\u5b9e\u73b0");
    }

    static void checkBounds(int off, int len, int size) {
        if ((off | len | off + len | size - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[size=");
        sb.append(this.size);
        sb.append(" cap=");
        sb.append(this.capacity);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public double[] toArray() {
        if (this.isDirect.booleanValue()) {
            throw new RuntimeException("\u6682\u65f6\u4e0d\u652f\u6301");
        }
        return this.heap;
    }

    @Override
    public void reset() {
        this.size = 0;
        this.capacity = this.beginSize / this.typeSize;
        if (this.isDirect.booleanValue()) {
            for (ByteBuffer bf : this.directBufferArr) {
                this.clean(bf);
            }
            this.directBufferArr = new ArrayList();
            this.isDirect = false;
        }
    }
}

