/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.spatial.grid;

import com.northpool.spatial.grid.IGridSystem;
import com.northpool.spatial.tool.SimpleGISTool;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanLine {
    Logger logger = LoggerFactory.getLogger(ScanLine.class);
    private ExecutorService executor;
    private Integer[] levels;
    private static int INT_EMTPY = -999999999;
    private HashMap<Integer, Set<String>> holder = new HashMap();
    private ArrayList<double[][]> features = new ArrayList();
    private IGridSystem grid;

    public HashMap<Integer, Set<String>> getExtents() {
        return this.holder;
    }

    public ScanLine(Integer threads, Integer[] levels, IGridSystem grid) {
        this.grid = grid;
        this.levels = levels;
        this.createHashMap();
    }

    private void createHashMap() {
        for (int i = 0; i < this.levels.length; ++i) {
            HashSet set = new HashSet();
            this.holder.put(this.levels[i], set);
        }
    }

    public void close() {
    }

    public void calculate(double[][] points) {
        for (int i = 0; i < this.levels.length; ++i) {
            Set s = this.calculateForEachLevel(points, this.levels[i]);
            this.holder.put(this.levels[i], s);
        }
    }

    private Set calculateForEachLevel(double[][] points, Integer level) {
        return this.polyRingCover(points, level);
    }

    private Set<String> polyRingCover(double[][] points, int level) {
        double[][] newPoly = this.simplify(points, level);
        double resolution = this.grid.getResolution(level);
        double minY = INT_EMTPY;
        double maxY = INT_EMTPY;
        for (int pathIndex = 0; pathIndex < newPoly.length; ++pathIndex) {
            double[] subPoints = newPoly[pathIndex];
            for (int i = 0; i < subPoints.length / 2; ++i) {
                double y = subPoints[i * 2 + 1];
                if (minY == (double)INT_EMTPY) {
                    minY = y;
                }
                if (maxY == (double)INT_EMTPY) {
                    maxY = y;
                }
                if (y >= maxY) {
                    maxY = y;
                }
                if (!(y < minY)) continue;
                minY = y;
            }
        }
        double gridExtendMaxY = maxY;
        double minX = 0.0;
        double maxX = (int)((this.grid.getMaxX() - this.grid.getMinX()) / resolution);
        HashSet<String> scanXY = new HashSet<String>();
        for (double scanlineY = minY; scanlineY <= gridExtendMaxY; scanlineY += 1.0) {
            long a1 = System.currentTimeMillis();
            Object scanline = null;
            scanline = new double[][]{{minX, scanlineY}, {maxX, scanlineY}};
            int Y = (int)(scanlineY / (double)this.grid.getBase());
            ArrayList<Double> scanlineXDoubleArray = new ArrayList<Double>();
            for (int pathIndex = 0; pathIndex < newPoly.length; ++pathIndex) {
                double[] intersection;
                double x;
                double[] subPoints = newPoly[pathIndex];
                if (subPoints.length <= 2) {
                    double x2 = (int)(subPoints[0] / (double)this.grid.getBase());
                    double y = (int)subPoints[1];
                    if (y != scanlineY) continue;
                    scanlineXDoubleArray.add(x2);
                    continue;
                }
                block6: for (int i = 0; i < subPoints.length / 2 - 1; ++i) {
                    double point1x = subPoints[i * 2];
                    double point1y = subPoints[i * 2 + 1];
                    double point2x = subPoints[i * 2 + 2];
                    double point2y = subPoints[i * 2 + 3];
                    if (point1y < scanlineY && point2y < scanlineY || point1y > scanlineY && point2y > scanlineY) continue;
                    if (point2y == scanlineY) {
                        double tmpY = point1y;
                        x = (int)(point2x / (double)this.grid.getBase());
                        scanlineXDoubleArray.add(x);
                        while (++i != subPoints.length / 2 - 1) {
                            boolean nextSide;
                            double pointNext2y;
                            double pointNext1x = subPoints[i * 2];
                            double pointNext1y = subPoints[i * 2 + 1];
                            double pointNext2x = 0.0;
                            try {
                                pointNext2x = subPoints[i * 2 + 2];
                            }
                            catch (Exception e) {
                                this.logger.warn("\u626b\u63cf\u7ebf\u5f02\u5e38", (Throwable)e);
                            }
                            if (pointNext1y == (pointNext2y = subPoints[i * 2 + 3]) && pointNext2y == scanlineY) continue;
                            boolean tmpYSide = scanlineY - tmpY > 0.0;
                            boolean bl = nextSide = scanlineY - pointNext2y > 0.0;
                            if (tmpYSide != nextSide) continue block6;
                            double xNext = (int)(pointNext2x / (double)this.grid.getBase());
                            scanlineXDoubleArray.add(xNext);
                            continue block6;
                        }
                        continue;
                    }
                    double[] intersection2 = SimpleGISTool.LINEINTERSECTS(scanline[0][0], scanline[0][1], scanline[1][0], scanline[1][1], point1x, point1y, point2x, point2y);
                    if (intersection2 == null) continue;
                    double x3 = (int)(intersection2[0] / (double)this.grid.getBase());
                    double y = (int)(intersection2[1] / (double)this.grid.getBase());
                    scanlineXDoubleArray.add(x3);
                }
                double point1x = subPoints[subPoints.length - 2];
                double point1y = subPoints[subPoints.length - 1];
                double point2x = subPoints[0];
                double point2y = subPoints[1];
                if (point1y < scanlineY && point2y < scanlineY || point1y > scanlineY && point2y > scanlineY || (intersection = SimpleGISTool.LINEINTERSECTS(scanline[0][0], scanline[0][1], scanline[1][0], scanline[1][1], point1x, point1y, point2x, point2y)) == null) continue;
                x = (int)(intersection[0] / (double)this.grid.getBase());
                double y = (int)(intersection[1] / (double)this.grid.getBase());
                scanlineXDoubleArray.add(x);
            }
            Collections.sort(scanlineXDoubleArray, new Comparator<Double>(){

                @Override
                public int compare(Double o1, Double o2) {
                    return o1.compareTo(o2);
                }
            });
            for (int intersectionsIndex = 0; intersectionsIndex < scanlineXDoubleArray.size(); ++intersectionsIndex) {
                double intersectionXEnter;
                if (intersectionsIndex % 2 != 0) continue;
                double intersectionXExit = intersectionXEnter = ((Double)scanlineXDoubleArray.get(intersectionsIndex)).doubleValue();
                if (intersectionsIndex < scanlineXDoubleArray.size() - 1) {
                    intersectionXExit = (Double)scanlineXDoubleArray.get(intersectionsIndex + 1);
                }
                int exitX = (int)intersectionXExit;
                for (int enterX = (int)intersectionXEnter; enterX <= exitX; ++enterX) {
                    String key = enterX + "_" + Y;
                    scanXY.add(key);
                }
            }
        }
        return scanXY;
    }

    private static long twoInt2Long(int low, int high) {
        return (long)low & 0xFFFFFFFFL | (long)high << 32 & 0xFFFFFFFF00000000L;
    }

    public static int[] long2Ints(long val) {
        int[] ret = new int[]{(int)(0xFFFFFFFFL & val), (int)((0xFFFFFFFF00000000L & val) >> 32)};
        return ret;
    }

    private double[][] simplify(double[][] points, int level) {
        double[][] newPoly = new double[points.length][];
        double resolution = this.grid.getResolution(level);
        for (int index = 0; index < newPoly.length; ++index) {
            double[] doubleArr = points[index];
            double[] parent = new double[]{-1.0, -1.0};
            DoubleBuffer buffer = DoubleBuffer.allocate(doubleArr.length);
            for (int i = 0; i < doubleArr.length / 2; ++i) {
                double x = doubleArr[i * 2];
                double y = doubleArr[i * 2 + 1];
                double _x = (int)((x - this.grid.getMinX()) / resolution);
                double _y = (int)((this.grid.getMaxY() - y) / resolution);
                if (parent[0] == -1.0 && parent[1] == -1.0) {
                    parent[0] = _x;
                    parent[1] = _y;
                    buffer.put(_x);
                    buffer.put(_y);
                    continue;
                }
                if (parent[0] == _x && parent[1] == _y) continue;
                parent[0] = _x;
                parent[1] = _y;
                buffer.put(_x);
                buffer.put(_y);
            }
            buffer.flip();
            double[] newCoordinates = new double[buffer.limit()];
            buffer.get(newCoordinates, 0, newCoordinates.length);
            newPoly[index] = newCoordinates;
        }
        return newPoly;
    }

    public static double[][] create(Geometry geom) throws Exception {
        int length = geom.getNumGeometries();
        double[][] darr = new double[length][];
        for (int i = 0; i < length; ++i) {
            Geometry sub = geom.getGeometryN(i);
            Coordinate[] cc = sub.getCoordinates();
            int cclength = cc.length;
            double[] subArr = new double[cclength * 2];
            for (int j = 0; j < cclength; ++j) {
                Coordinate c = sub.getCoordinates()[j];
                subArr[j * 2] = c.x;
                subArr[j * 2 + 1] = c.y;
            }
            darr[i] = subArr;
        }
        return darr;
    }
}

