/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.spatial;

import com.northpool.spatial.CRSConstants;
import com.northpool.spatial.grid.Constants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Constants {
    public static final List<String> GEO_TYPE_ARR;

    public static SPATIAL_UNIT getSpatialUnitBySRID(Integer srid) {
        Constants.GRID_UNIT sridUnit = Constants.getGridUnitBySrid(srid);
        if (Constants.GRID_UNIT.meter == sridUnit) {
            return SPATIAL_UNIT.meter;
        }
        return SPATIAL_UNIT.degree;
    }

    public static Constants.GRID_UNIT getGridUnitBySrid(Integer srid) {
        return CRSConstants.getGridUnit(srid);
    }

    static {
        GEO_TYPE[] values;
        ArrayList<String> i = new ArrayList<String>();
        for (GEO_TYPE type : values = GEO_TYPE.values()) {
            i.add(type.name());
        }
        GEO_TYPE_ARR = Collections.unmodifiableList(i);
    }

    public static enum LAYER_TYPE {
        RASTER,
        VECTOR;

    }

    public static enum SPATIAL_TYPE {
        sdo,
        hexwkb,
        sde,
        shape,
        wkb,
        wkt,
        jtsGeometry,
        esriGeometry,
        gdalGeometry,
        geoBuffer;

    }

    public static enum SPATIAL_UNIT {
        degree,
        meter;

    }

    public static enum GEO_TYPE {
        UNKNOWN,
        POINT,
        LINESTRING,
        POLYGON,
        MULTIPOINT,
        MULTILINESTRING,
        MULTIPOLYGON,
        COLLECTION,
        GEOMETRY;

    }
}

