/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.pixel.resmple;

import com.northpool.pixel.resmple.Fn1DResamplingFunction;
import com.northpool.pixel.resmple.ImageSrc;
import com.northpool.pixel.resmple.NearestNeighbour;
import com.northpool.pixel.resmple.Resample1DBicubic;
import com.northpool.pixel.resmple.Resample1DBilinear;
import java.nio.ByteBuffer;

public class Resample {
    public static final int modeNearestNeighbour = 0;
    public static final int modeBilinear = 1;
    public static final int modeBicubic = 2;

    static Fn1DResamplingFunction get1DResamplingFunction(Mode mode) {
        switch (mode) {
            case modeNearestNeighbour: {
                return NearestNeighbour.INSTANCE;
            }
            case modeBilinear: {
                return Resample1DBilinear.INSTANCE;
            }
            case modeBicubic: {
                return Resample1DBicubic.INSTANCE;
            }
        }
        throw new RuntimeException("No resampling function for mode : " + mode.name());
    }

    public static ImageSrc resampleImageFromBuffer(ImageSrc image, int channelSize, int dstWidth, int dstHeight, Mode mode) {
        Fn1DResamplingFunction function = Resample.get1DResamplingFunction(mode);
        int numBytesPerPixel = channelSize;
        int srcWidth = image.width;
        int srcHeight = image.height;
        int srcBytesPerLine = srcWidth * numBytesPerPixel;
        ByteBuffer srcBuffer = image.dstBuffer;
        int intermediateWidth = dstWidth;
        int intermediateHeight = srcHeight;
        int intermediateBytesPerLine = dstWidth * numBytesPerPixel;
        ByteBuffer intermediateBuffer = ByteBuffer.allocateDirect(intermediateHeight * intermediateBytesPerLine);
        int dstBytesPerLine = intermediateBytesPerLine;
        ByteBuffer dstBuffer = ByteBuffer.allocateDirect(dstHeight * dstBytesPerLine);
        for (int row = 0; row < srcHeight; ++row) {
            function.resampling(intermediateBuffer, row * intermediateBytesPerLine, intermediateWidth, numBytesPerPixel, srcBuffer, row * srcBytesPerLine, srcWidth, numBytesPerPixel, numBytesPerPixel);
        }
        for (int col = 0; col < intermediateWidth; ++col) {
            function.resampling(dstBuffer, col * numBytesPerPixel, dstHeight, dstBytesPerLine, intermediateBuffer, col * numBytesPerPixel, intermediateHeight, intermediateBytesPerLine, numBytesPerPixel);
        }
        return new ImageSrc(dstBuffer, dstWidth, dstHeight, numBytesPerPixel);
    }

    public static enum Mode {
        modeNearestNeighbour,
        modeBilinear,
        modeBicubic;

    }
}

