/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.commons.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class DateUtility {
    private static final long ONE_DAY = 86400000L;
    private static int weeks = 0;

    public static String getCurrentDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String s = df.format(new Date());
        return s;
    }

    public static String getCurrentTime() {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        String s = df.format(new Date());
        return s;
    }

    public static String getCurrentm() {
        SimpleDateFormat df = new SimpleDateFormat("ss");
        String s = df.format(new Date());
        return s;
    }

    public static String getCurrentHhMmSs() {
        SimpleDateFormat df = new SimpleDateFormat("HHmmss");
        String s = df.format(new Date());
        return s;
    }

    public static String getCurrentYear() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy");
        String s = df.format(new Date());
        return s;
    }

    public static String getYear(Date d) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy");
        String s = df.format(d);
        return s;
    }

    public static String getCurrentMonth() {
        SimpleDateFormat df = new SimpleDateFormat("MM");
        String s = df.format(new Date());
        return s;
    }

    public static String getDayInWeek(String sDate) {
        Date date = DateUtility.strToDate(sDate);
        SimpleDateFormat df = new SimpleDateFormat("EEE");
        String s = df.format(date);
        return s;
    }

    public static Date strToDate(String str) {
        Date date = null;
        if (str != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                date = df.parse(str);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    public static Date strToDateTime(String str) {
        Date date = null;
        if (str != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                date = df.parse(str);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    public static String getDAT() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String s = df.format(new Date());
        return s;
    }

    public static String dateTimeToStr(Date date) {
        String str = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (date != null) {
            str = df.format(date);
        }
        return str;
    }

    public static String dateToStr(Date date) {
        String str = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (date != null) {
            str = df.format(date);
        }
        return str;
    }

    public static String dateToYearMonthDay(Date date) {
        String str = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (date != null) {
            str = df.format(date);
        }
        return str;
    }

    public static String dateToYearMonth(Date date) {
        String str = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
        if (date != null) {
            str = df.format(date);
        }
        return str;
    }

    public static String dateToPathYearMonthDay(Date date) {
        String str = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74\\MM\u6708\\dd\u65e5");
        if (date != null) {
            str = df.format(date);
        }
        return str;
    }

    public static String dateToPathYearMonthDaySplit(Date date) {
        String str = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74,MM\u6708,dd\u65e5");
        if (date != null) {
            str = df.format(date);
        }
        return str;
    }

    public static String dateToPathYearMonth(Date date) {
        String str = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74\\MM\u6708");
        if (date != null) {
            str = df.format(date);
        }
        return str;
    }

    public static String dateToPathYearMonthSplit(Date date) {
        String str = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74,MM\u6708");
        if (date != null) {
            str = df.format(date);
        }
        return str;
    }

    public static String dateToPathYear(Date date) {
        String str = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74");
        if (date != null) {
            str = df.format(date);
        }
        return str;
    }

    public static String dateToStrCh(Date date) {
        String str = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy MM dd ");
        if (date != null) {
            str = df.format(date);
        }
        return str;
    }

    public static Date add(Date date, int i) {
        date = new Date(date.getTime() + (long)i * 86400000L);
        return date;
    }

    public static Date add(Date date) {
        return DateUtility.add(date, 1);
    }

    public static Date sub(Date date) {
        return DateUtility.add(date, -1);
    }

    public static String getBeforeDate() {
        Date date = DateUtility.sub(new Date());
        return DateUtility.dateToStr(date);
    }

    public static String getCurrentDateTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String s = df.format(new Date());
        return s;
    }

    public static String getCurrentDateWeek() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy MM dd EEE");
        String s = df.format(new Date());
        return s;
    }

    public static String getCurrentDateWeekEn() {
        SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy ", new Locale("en"));
        String s = df.format(new Date());
        return s;
    }

    public static int compareMonth(String startYear, String startMonth, String endYear, String endMonth) {
        return (Integer.parseInt(endYear) - Integer.parseInt(startYear)) * 12 + (Integer.parseInt(endMonth) - Integer.parseInt(startMonth));
    }

    public static String getYearMonth(String sDate) {
        Date date1 = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String s = null;
        try {
            date1 = df.parse(sDate);
            df.applyPattern("yyMM");
            s = df.format(date1);
        }
        catch (ParseException e) {
            return s;
        }
        return s;
    }

    public static String getYearMonth(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyMM");
        String s = null;
        s = df.format(date);
        return s;
    }

    public static String getMonthDay(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("MM dd ");
        String s = null;
        s = df.format(date);
        return s;
    }

    public static String getYearMonthDay(String sDate) {
        Date date1 = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String s = null;
        try {
            date1 = df.parse(sDate);
            df.applyPattern("yyMMdd");
            s = df.format(date1);
        }
        catch (ParseException e) {
            return s;
        }
        return s;
    }

    public static String getStartQueryTime(String date) {
        return DateUtility.dateToStr(DateUtility.strToDate(date)) + " 00:00:00";
    }

    public static String getEndQueryTime(String date) {
        return DateUtility.dateToStr(DateUtility.strToDate(date)) + " 23:59:59";
    }

    public static String getMonth(String sDate) {
        Date date1 = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String s = null;
        try {
            date1 = df.parse(sDate);
            df.applyPattern("MM");
            s = df.format(date1);
        }
        catch (ParseException e) {
            return s;
        }
        return s;
    }

    public static int compareDate(String sDate1, String sDate2) {
        Date date1 = null;
        Date date2 = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date1 = dateFormat.parse(sDate1);
            date2 = dateFormat.parse(sDate2);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        long dif = 0L;
        dif = date2.after(date1) ? (date2.getTime() - date1.getTime()) / 1000L / 60L / 60L / 24L : (date1.getTime() - date2.getTime()) / 1000L / 60L / 60L / 24L;
        return (int)dif;
    }

    public static int getDate(String sDate, String sTag) {
        int iSecondMinusPos = sDate.lastIndexOf(45);
        if (sTag.equalsIgnoreCase("y")) {
            return Integer.parseInt(sDate.substring(0, 4));
        }
        if (sTag.equalsIgnoreCase("m")) {
            return Integer.parseInt(sDate.substring(5, iSecondMinusPos));
        }
        return Integer.parseInt(sDate.substring(iSecondMinusPos + 1));
    }

    public static int getDayOfWeek() {
        Calendar toDay = Calendar.getInstance();
        toDay.setFirstDayOfWeek(2);
        int ret = toDay.get(7) - 1;
        if (ret == 0) {
            ret = 7;
        }
        return ret;
    }

    public static String getFirstDayOfMonth() {
        Calendar ca = Calendar.getInstance();
        ca.setTime(new Date());
        ca.set(5, 1);
        Date firstDate = ca.getTime();
        ca.add(2, 1);
        ca.add(5, -1);
        Date lastDate = ca.getTime();
        return DateUtility.dateToStr(firstDate);
    }

    public static String getFirstDayOfMonth(Date d) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(d);
        ca.set(5, 1);
        Date firstDate = ca.getTime();
        ca.add(2, 1);
        ca.add(5, -1);
        Date lastDate = ca.getTime();
        return DateUtility.dateToStr(firstDate);
    }

    public static String getLastDayOfMonth(Date d) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(d);
        ca.set(5, 1);
        Date firstDate = ca.getTime();
        ca.add(2, 1);
        ca.add(5, -1);
        Date lastDate = ca.getTime();
        return DateUtility.dateToStr(lastDate);
    }

    public static String getLastDayOfMonth() {
        Calendar ca = Calendar.getInstance();
        ca.setTime(new Date());
        ca.set(5, 1);
        Date firstDate = ca.getTime();
        ca.add(2, 1);
        ca.add(5, -1);
        Date lastDate = ca.getTime();
        return DateUtility.dateToStr(lastDate);
    }

    public static void main(String[] args) {
        System.out.println(DateUtility.getCurrentTime());
    }

    public static String yesterday() {
        Calendar calendar = Calendar.getInstance();
        StringBuffer param = new StringBuffer();
        calendar.add(5, -1);
        param.append(String.valueOf(calendar.get(1))).append("-").append(String.valueOf(calendar.get(2) + 1)).append("-").append(String.valueOf(calendar.get(5)));
        return param.toString();
    }

    public static String lately7Day() {
        Calendar calendar = Calendar.getInstance();
        StringBuffer param = new StringBuffer();
        calendar.add(5, -7);
        param.append(String.valueOf(calendar.get(1))).append("-").append(String.valueOf(calendar.get(2) + 1)).append("-").append(String.valueOf(calendar.get(5)));
        return param.toString() + "," + DateUtility.dateToYearMonthDay(new Date());
    }

    public static String lately30Day() {
        Calendar calendar = Calendar.getInstance();
        StringBuffer param = new StringBuffer();
        calendar.add(5, -30);
        return DateUtility.dateToYearMonthDay(calendar.getTime()) + "," + DateUtility.dateToYearMonthDay(new Date());
    }

    public static String lastYear() {
        Calendar calendar = Calendar.getInstance();
        StringBuffer param = new StringBuffer();
        calendar.add(1, -1);
        param.append(String.valueOf(calendar.get(1)));
        return param.toString();
    }

    public static String LastMonth() {
        Calendar calendar = Calendar.getInstance();
        StringBuffer param = new StringBuffer();
        calendar.add(2, -1);
        param.append(String.valueOf(calendar.get(1))).append("-").append(String.valueOf(calendar.get(2) + 1));
        return param.toString();
    }

    public static String thisWeek() {
        Calendar c = Calendar.getInstance();
        int weekday = c.get(7) - 1;
        System.out.println("\u5468\u5929\u6570\uff1a" + weekday);
        c.add(5, -weekday);
        String thisWeek = DateUtility.dateToStr(c.getTime());
        System.out.println("\u672c\u5468\u5f00\u59cb\u65f6\u95f4\uff1a" + DateUtility.dateToStr(c.getTime()));
        c.add(5, 7);
        System.out.println("\u672c\u5468\u5f00\u59cb\u7ed3\u675f\uff1a" + DateUtility.dateToStr(c.getTime()));
        thisWeek = thisWeek + "," + DateUtility.dateToStr(c.getTime());
        return thisWeek;
    }

    public static String lastWeek() {
        String beginTime = DateUtility.getPreviousWeekday();
        String endTime = DateUtility.getPreviousWeekSunday();
        return beginTime + "," + endTime;
    }

    public static String getPreviousWeekSunday() {
        weeks = 0;
        int mondayPlus = DateUtility.getMondayPlus();
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.add(5, mondayPlus + --weeks);
        Date monday = currentDate.getTime();
        String preMonday = DateUtility.dateToYearMonthDay(monday);
        return preMonday;
    }

    public static String getPreviousWeekday() {
        int mondayPlus = DateUtility.getMondayPlus();
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.add(5, mondayPlus + 7 * --weeks);
        Date monday = currentDate.getTime();
        String preMonday = DateUtility.dateToYearMonthDay(monday);
        return preMonday;
    }

    private static int getMondayPlus() {
        Calendar cd = Calendar.getInstance();
        int dayOfWeek = cd.get(7) - 1;
        if (dayOfWeek == 1) {
            return 0;
        }
        return 1 - dayOfWeek;
    }

    public static String getDateAddOne(String str) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtility.strToDateTime(str));
        calendar.add(13, 1);
        String s = DateUtility.dateTimeToStr(calendar.getTime());
        return s;
    }

    public static String getDateSubtractOne(String str) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtility.strToDateTime(str));
        calendar.add(13, -1);
        String s = DateUtility.dateTimeToStr(calendar.getTime());
        return s;
    }

    public static Calendar setStartDay(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal;
    }

    public static Calendar setEndDay(Calendar cal) {
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal;
    }

    public static void copyYearMonthDay(Calendar destCal, Calendar sourceCal) {
        destCal.set(1, sourceCal.get(1));
        destCal.set(2, sourceCal.get(2));
        destCal.set(5, sourceCal.get(5));
    }

    public static Date nDaysAfterOneDate(Date basicDate, int n) {
        long nDay = (basicDate.getTime() / 86400000L + 1L + (long)n) * 86400000L;
        basicDate.setTime(nDay);
        return basicDate;
    }
}

