/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.spatial.wkt;

import com.northpool.spatial.AGeomEncoder;
import com.northpool.spatial.Constants;
import com.northpool.spatial.GeomEncoder;
import com.northpool.spatial.geofeature.GeoBuffer;
import java.nio.ByteOrder;

@AGeomEncoder(type=Constants.SPATIAL_TYPE.wkt)
public class WktEncoder
implements GeomEncoder<String> {
    public static final WktEncoder ENCODER = new WktEncoder();

    @Override
    public String fromGeoBuffer(GeoBuffer geoBuffer) {
        return this.fromGeoBuffer(geoBuffer, true, ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public String fromGeoBuffer(GeoBuffer geoBuffer, boolean includeSrid, ByteOrder byteOrder) {
        String wkt = geoBuffer.toJTSGeometry().toString();
        if (includeSrid) {
            int srid = geoBuffer.getSRID();
            if (srid == 0) {
                return wkt;
            }
            return "SRID=" + srid + ";" + wkt;
        }
        return wkt;
    }
}

