/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.commons.concurrent;

import com.northpool.commons.concurrent.BlockThreadPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class DynamicCountDownLatch {
    final AtomicLong count = new AtomicLong(0L);
    private final Sync sync;

    public DynamicCountDownLatch(int num) {
        this.sync = new Sync(num);
    }

    public DynamicCountDownLatch() {
        this.sync = new Sync(0);
    }

    public void await() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, unit.toNanos(timeout));
    }

    public void addNum(int num) {
        this.sync._setState(num);
    }

    public void countDown(int num) {
        this.sync.releaseShared(num);
    }

    public long getCount() {
        return this.sync.getCount();
    }

    public String toString() {
        return super.toString() + "[Count = " + this.sync.getCount() + "]";
    }

    public static void main(String[] aaa) throws InterruptedException {
        DynamicCountDownLatch count = new DynamicCountDownLatch(0);
        BlockThreadPool threadPool = new BlockThreadPool(2, 1);
        count.addNum(8);
        for (int i = 0; i < 10; ++i) {
            threadPool.execute(() -> {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.out.println(count.getCount() + "----------------------a");
                count.countDown(1);
            });
        }
        count.await();
        System.out.println("aaaa");
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 4982264981922014374L;

        Sync(int count) {
            this.setState(count);
        }

        synchronized void _setState(int count) {
            int nextc;
            int c;
            while (!this.compareAndSetState(c = this.getState(), nextc = c + count)) {
            }
        }

        int getCount() {
            return this.getState();
        }

        @Override
        protected int tryAcquireShared(int acquires) {
            return this.getState() == 0 ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int releases) {
            int nextc;
            int c;
            do {
                if ((c = this.getState()) != 0) continue;
                return false;
            } while (!this.compareAndSetState(c, nextc = c - releases));
            return nextc == 0;
        }
    }
}

