/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.commons.event;

import com.northpool.commons.event.Listener;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;

public class EventContainer<T extends Listener> {
    private final ConcurrentHashMap<String, ConcurrentLinkedQueue<T>> eventMap = new ConcurrentHashMap();

    public void on(String eventName, T listener) {
        ConcurrentLinkedQueue<T> queue = this.eventMap.get(eventName);
        if (queue == null) {
            queue = this.createQueue(eventName);
            this.eventMap.put(eventName, queue);
        }
        queue.add(listener);
    }

    private synchronized ConcurrentLinkedQueue<T> createQueue(String eventName) {
        ConcurrentLinkedQueue<Object> queue = this.eventMap.get(eventName);
        if (queue == null) {
            queue = new ConcurrentLinkedQueue();
        }
        return queue;
    }

    public void un(String eventName, T listener) {
        ConcurrentLinkedQueue<T> queue = this.eventMap.get(eventName);
        if (queue == null) {
            return;
        }
        queue.remove(listener);
    }

    public void syncFireEvent(String eventName, Object ... parameter) {
        ConcurrentLinkedQueue<T> queue = this.eventMap.get(eventName);
        if (queue == null) {
            return;
        }
        queue.forEach(listener -> listener.fire(parameter));
    }

    public void asyncFireEvent(String eventName, Executor executor, Object ... parameter) {
        ConcurrentLinkedQueue<T> queue = this.eventMap.get(eventName);
        if (queue == null) {
            return;
        }
        queue.forEach(listener -> executor.execute(() -> listener.fire(parameter)));
    }
}

