/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.commons.reflect.invoker;

import com.northpool.commons.reflect.Invoker;
import com.northpool.commons.reflect.InvokerManager;
import com.northpool.commons.reflect.Reflect;
import com.northpool.type.Types;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import org.apache.commons.lang3.reflect.MethodUtils;

public class JavassistInvokerManagerImpl
implements InvokerManager {
    private static final Map<Method, Invoker> INVOKER_MAP = new WeakHashMap<Method, Invoker>();
    private static final Map<Integer, Invoker> PUBLIC_INVOKER_MAP = new WeakHashMap<Integer, Invoker>();
    private static JavassistInvokerManagerImpl _InvokerManagerImpl = new JavassistInvokerManagerImpl();

    public static InvokerManager getInstance() {
        return _InvokerManagerImpl;
    }

    private String argumentTypesToString(Class<?>[] argTypes) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                Class<?> c;
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append((c = argTypes[i]) == null ? "null" : c.getName());
            }
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public Object invokePublic(Object host, String name, Object ... args) throws NoSuchMethodException {
        Object[] objectArray;
        Class<?> clazz;
        Class<?> clazz2 = clazz = host instanceof Class ? (Class<?>)host : host.getClass();
        if (args == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = null;
        } else {
            objectArray = args;
        }
        args = objectArray;
        Object[] paramTypes = new Class[args.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramTypes[i] = args[i] == null ? null : args[i].getClass();
        }
        int[] keys = new int[]{clazz.hashCode(), name.hashCode(), Arrays.hashCode(paramTypes)};
        int key = Arrays.hashCode(keys);
        Invoker invoker = PUBLIC_INVOKER_MAP.get(key);
        if (invoker == null) {
            Method method = MethodUtils.getMatchingAccessibleMethod(clazz, (String)name, (Class[])paramTypes);
            if (method == null) {
                throw new NoSuchMethodException(clazz.getName() + "." + name + this.argumentTypesToString((Class<?>[])paramTypes));
            }
            invoker = this.newInvoker(method);
            PUBLIC_INVOKER_MAP.put(key, invoker);
        }
        return invoker.invoke(host, args);
    }

    @Override
    public Invoker newInvoker(Method method) {
        Invoker invoker = INVOKER_MAP.get(method);
        if (invoker == null) {
            StringBuilder proxyClassNameBuilder = new StringBuilder();
            proxyClassNameBuilder.append("proxy.invoker.method$");
            proxyClassNameBuilder.append(method.hashCode());
            String proxyClassName = proxyClassNameBuilder.toString();
            try {
                Class<Object> proxyClass = null;
                try {
                    proxyClass = Reflect.getClassLoader() == null ? Class.forName(proxyClassName) : Reflect.getClassLoader().loadClass(proxyClassName);
                }
                catch (Throwable e) {
                    try {
                        ClassPool cp = ClassPool.getDefault();
                        cp.appendClassPath((ClassPath)new ClassClassPath(Invoker.class));
                        CtClass cc = cp.makeClass(proxyClassName);
                        cc.addField(CtField.make((String)"private java.lang.reflect.Method m;", (CtClass)cc));
                        CtConstructor ctConstructor = new CtConstructor(new CtClass[]{cp.get(Method.class.getName())}, cc);
                        ctConstructor.setBody("{this.m=(java.lang.reflect.Method)$1;}");
                        cc.addConstructor(ctConstructor);
                        cc.addInterface(cp.get(Invoker.class.getName()));
                        cc.addMethod(CtMethod.make((String)"public java.lang.reflect.Method method(){return m;}", (CtClass)cc));
                        StringBuilder invokeCode = new StringBuilder();
                        invokeCode.append("public Object invoke(Object host, Object[] args){");
                        StringBuilder parameterCode = new StringBuilder();
                        for (int i = 0; i < method.getParameterTypes().length; ++i) {
                            if (i > 0) {
                                parameterCode.append(",");
                            }
                            Class<?> parameterType = method.getParameterTypes()[i];
                            parameterCode.append(this.generateCast("args[" + i + "]", Object.class, parameterType));
                        }
                        if (method.getParameterTypes().length > 0) {
                            invokeCode.append("if(args==null||args.length!=");
                            invokeCode.append(method.getParameterTypes().length);
                            invokeCode.append(")throw new IllegalArgumentException(\"wrong number of arguments\");");
                        }
                        StringBuilder executeCode = new StringBuilder();
                        executeCode.append("((");
                        executeCode.append(method.getDeclaringClass().getCanonicalName());
                        executeCode.append(")");
                        String objCode = Modifier.isStatic(method.getModifiers()) ? "" : "host";
                        executeCode.append(objCode);
                        executeCode.append(").");
                        executeCode.append(method.getName());
                        executeCode.append("(");
                        executeCode.append((CharSequence)parameterCode);
                        executeCode.append(")");
                        if (!method.getReturnType().equals(Void.TYPE)) {
                            invokeCode.append("return ");
                            invokeCode.append(this.generateCast(executeCode.toString(), method.getReturnType(), Object.class));
                            invokeCode.append(";");
                        } else {
                            invokeCode.append(executeCode.toString());
                            invokeCode.append(";return null;");
                        }
                        invokeCode.append("}");
                        cc.addMethod(CtMethod.make((String)invokeCode.toString(), (CtClass)cc));
                        proxyClass = cc.toClass();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        throw new RuntimeException(e);
                    }
                }
                invoker = (Invoker)proxyClass.getConstructor(Method.class).newInstance(method);
                INVOKER_MAP.put(method, invoker);
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
        return invoker;
    }

    @Override
    public <T> T newInvoker(Class<T> superClass, Class<?> hostClass, String methodName, Class<?>[] hostMethodParameterTypes, Class<?> hostMethodReturnType) {
        try {
            Class<Object> proxyClass;
            methodName = methodName == null ? null : methodName.trim();
            StringBuilder proxyClassNameBuilder = new StringBuilder();
            proxyClassNameBuilder.append("proxy.invoker$");
            proxyClassNameBuilder.append((long)superClass.hashCode() + 10000000000L);
            proxyClassNameBuilder.append("$");
            proxyClassNameBuilder.append((long)hostClass.hashCode() + 10000000000L);
            proxyClassNameBuilder.append("$");
            if (methodName != null && !methodName.equals("")) {
                proxyClassNameBuilder.append(methodName);
            }
            proxyClassNameBuilder.append("$");
            if (hostMethodParameterTypes != null && hostMethodParameterTypes.length > 0) {
                proxyClassNameBuilder.append(10000000000L + (long)Arrays.hashCode(hostMethodParameterTypes));
            }
            proxyClassNameBuilder.append("$");
            if (hostMethodReturnType != null) {
                proxyClassNameBuilder.append(10000000000L + (long)hostMethodReturnType.hashCode());
            }
            String proxyClassName = proxyClassNameBuilder.toString();
            try {
                proxyClass = Reflect.getClassLoader() == null ? Class.forName(proxyClassName) : Reflect.getClassLoader().loadClass(proxyClassName);
            }
            catch (Exception ex) {
                Method[] methods;
                ClassPool cp = new ClassPool(true);
                CtClass cc = cp.makeClass(proxyClassName);
                if (superClass.isInterface()) {
                    cc.addInterface(cp.get(superClass.getName()));
                } else {
                    cc.setSuperclass(cp.get(superClass.getName()));
                }
                for (Method method : methods = superClass.getMethods()) {
                    int mod = method.getModifiers();
                    if (Modifier.isFinal(mod) || Modifier.isStatic(mod)) continue;
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    if (parameterTypes.length < 1 || !hostClass.isAssignableFrom(parameterTypes[0]) && !parameterTypes[0].isAssignableFrom(hostClass)) {
                        throw new IllegalArgumentException("The first argument is not a host instance");
                    }
                    if (hostMethodParameterTypes != null && hostMethodParameterTypes.length != parameterTypes.length - 1) {
                        throw new IllegalArgumentException(String.format("The host method parameter types'number should be %d", parameterTypes.length - 1));
                    }
                    Class<?> returnType = method.getReturnType();
                    StringBuilder methodCode = new StringBuilder();
                    StringBuilder paramCode = new StringBuilder();
                    methodCode.append("public ");
                    methodCode.append(returnType.getCanonicalName());
                    methodCode.append(" ");
                    methodCode.append(method.getName());
                    methodCode.append("(");
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        String canonicalName = parameterTypes[i].getCanonicalName();
                        if (i > 0) {
                            String param;
                            methodCode.append(",");
                            if (i > 1) {
                                paramCode.append(",");
                            }
                            if (hostMethodParameterTypes != null) {
                                param = this.generateCast("p" + i, parameterTypes[i], hostMethodParameterTypes[i - 1]);
                                paramCode.append(param);
                            } else {
                                param = this.generateCast("p" + i, parameterTypes[i], parameterTypes[i - 1]);
                                paramCode.append(param);
                            }
                        }
                        methodCode.append(canonicalName);
                        methodCode.append(" p");
                        methodCode.append(i);
                    }
                    methodCode.append("){");
                    StringBuilder executeCode = new StringBuilder();
                    executeCode.append("((");
                    executeCode.append(hostClass.getCanonicalName());
                    executeCode.append(")p0).");
                    if (methodName == null) {
                        executeCode.append(method.getName());
                    } else {
                        executeCode.append(methodName);
                    }
                    executeCode.append("(");
                    executeCode.append((CharSequence)paramCode);
                    executeCode.append(")");
                    if (!returnType.equals(Void.TYPE)) {
                        methodCode.append("return ");
                        hostMethodReturnType = hostMethodReturnType == null ? returnType : hostMethodReturnType;
                        String returnCode = this.generateCast(executeCode.toString(), hostMethodReturnType, returnType);
                        methodCode.append(returnCode);
                    } else {
                        methodCode.append((CharSequence)executeCode);
                    }
                    methodCode.append(";");
                    methodCode.append("}");
                    cc.addMethod(CtMethod.make((String)methodCode.toString(), (CtClass)cc));
                }
                proxyClass = cc.toClass();
            }
            return (T)proxyClass.newInstance();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private String generateCast(String arg, Class<?> fromClass, Class<?> toClass) {
        StringBuilder cast = new StringBuilder();
        if (fromClass.isPrimitive() && !toClass.isPrimitive()) {
            Class<?> wraperClass = toClass;
            if (!Types.isWraper(toClass)) {
                wraperClass = Types.getWraper(fromClass);
            }
            cast.append("(");
            cast.append(toClass.getCanonicalName());
            cast.append(")");
            cast.append(wraperClass.getCanonicalName());
            cast.append(".valueOf((");
            cast.append(Types.getPrimitiveType(wraperClass).getCanonicalName());
            cast.append(")");
            cast.append(arg);
            cast.append(")");
        } else if (!fromClass.isPrimitive() && toClass.isPrimitive()) {
            cast.append("(");
            cast.append(toClass.getCanonicalName());
            cast.append(")");
            Class<?> wraperClass = fromClass;
            if (!Types.isWraper(fromClass)) {
                wraperClass = Types.getWraper(toClass);
                cast.append("((");
                if (Number.class.isAssignableFrom(wraperClass)) {
                    cast.append(Number.class.getCanonicalName());
                } else {
                    cast.append(wraperClass.getCanonicalName());
                }
                cast.append(")");
                cast.append(arg);
                cast.append(")");
            } else {
                cast.append(arg);
            }
            cast.append(".");
            cast.append(Types.getPrimitiveType(wraperClass).getCanonicalName());
            cast.append("Value()");
        } else {
            cast.append("(");
            cast.append(toClass.getCanonicalName());
            cast.append(")");
            cast.append(arg);
        }
        return cast.toString();
    }

    @Override
    public <T> T newInvoker(Class<T> superClass, Class<?> hostClass, String methodName) {
        return this.newInvoker(superClass, hostClass, methodName, null, null);
    }

    @Override
    public <T> T newInvoker(Class<T> superClass, Class<?> hostClass) {
        return this.newInvoker(superClass, hostClass, null);
    }
}

