/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.commons.reflect;

import com.northpool.commons.reflect.BeanHolder;
import com.northpool.commons.reflect.BeanHolderManager;
import com.northpool.commons.reflect.FieldHolder;
import com.northpool.commons.reflect.Function;
import com.northpool.commons.reflect.Reflect;
import com.northpool.commons.reflect.ReflectFindException;
import com.northpool.commons.util.StringUtility;
import com.northpool.exception.CommonException;
import com.northpool.type.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Bean {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> BeanHolder<T> getBeanHolder(Class<T> clazz) {
        BeanHolderManager manager = Reflect.getBeanHolderManager();
        BeanHolder<T> holder = manager.getBeanHolder(clazz);
        if (holder != null) return holder;
        Class<Bean> clazz2 = Bean.class;
        synchronized (Bean.class) {
            if (holder != null) return holder;
            holder = manager.createBeanHolder(clazz);
            manager.registerBeanHolder(clazz, holder, false);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return holder;
        }
    }

    public static <T> T newInstance(Class<T> clazz) {
        return Bean.getBeanHolder(clazz).getNewInstance();
    }

    public static <T> Map<String, Object> getObjectValue(T obj) {
        if (obj instanceof Map) {
            try {
                Map values = (Map)obj;
                return values;
            }
            catch (Exception e) {
                throw new RuntimeException("map\u7c7b\u578b\u53ea\u80fd\u662fMap<String,Object>\u7c7b\u578b");
            }
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        BeanHolder<?> holder = Bean.getBeanHolder(obj.getClass());
        for (Map.Entry<String, FieldHolder> e : holder.getFieldMap().entrySet()) {
            String name = e.getKey();
            Object value = e.getValue().getReaderInvoker().invoke(obj, null);
            m.put(name, value);
        }
        return m;
    }

    public static <T> Class<?> getObjectTypeByFieldName(T obj, String fieldName) {
        BeanHolder<?> holder = Bean.getBeanHolder(obj.getClass());
        FieldHolder fieldHolder = holder.getFieldMap().get(fieldName);
        if (fieldHolder == null) {
            return null;
        }
        return fieldHolder.getFieldType();
    }

    public static <T> Object getObjectValueByFieldName(T obj, String fieldName) {
        if (obj instanceof Map) {
            Map m = (Map)obj;
            return m.get(fieldName);
        }
        BeanHolder<?> holder = Bean.getBeanHolder(obj.getClass());
        FieldHolder fieldHolder = holder.getFieldMap().get(fieldName);
        if (fieldHolder == null) {
            fieldHolder = holder.getPrivateFieldMap().get(fieldName);
        }
        if (fieldHolder == null) {
            return null;
        }
        if (fieldHolder.getReaderInvoker() == null) {
            return null;
        }
        return fieldHolder.getReaderInvoker().invoke(obj, null);
    }

    @Deprecated
    public static <T> void setObjectValueByFieldName(T obj, Map<String, Object> m, Boolean checkToObjField) {
        Bean.setObjectValueByFieldName(obj, m);
    }

    public static <T> void setObjectValueByFieldName(T obj, Map<String, ?> m) {
        Map<String, FieldHolder> filedMap = Bean.getBeanHolder(obj.getClass()).getFieldMap();
        m.forEach((key, value) -> {
            String fieldName = key;
            FieldHolder fieldHolder = (FieldHolder)filedMap.get(fieldName);
            if (fieldHolder == null) {
                return;
            }
            fieldHolder.getWriteInvoker().invoke(obj, new Object[]{value});
        });
    }

    public static <T> void setSingleObjectValueByPrivateFieldName(T obj, String fieldName, Object value) throws Exception {
        Map<String, FieldHolder> filedMap = Bean.getBeanHolder(obj.getClass()).getPrivateFieldMap();
        FieldHolder fieldHolder = filedMap.get(fieldName);
        if (fieldHolder == null) {
            throw new ReflectFindException("\u6ca1\u6709\u627e\u5230" + fieldName);
        }
        if (value == null) {
            fieldHolder.getWriteInvoker().invoke(obj, new Object[]{null});
            return;
        }
        Class<?> clazz = fieldHolder.getFieldType();
        Class<?> clazz1 = value.getClass();
        if (clazz.getName().equals(clazz1.getName())) {
            fieldHolder.getWriteInvoker().invoke(obj, new Object[]{value});
        } else {
            Object newValue = Types.convert(value, clazz);
            fieldHolder.getWriteInvoker().invoke(obj, new Object[]{newValue});
        }
    }

    public static <T> void setSingleObjectValueByFieldName(T obj, String fieldName, Object value) throws Exception {
        Map<String, FieldHolder> filedMap = Bean.getBeanHolder(obj.getClass()).getFieldMap();
        FieldHolder fieldHolder = filedMap.get(fieldName);
        if (fieldHolder == null) {
            throw new ReflectFindException("\u6ca1\u6709\u627e\u5230" + fieldName);
        }
        if (value == null) {
            fieldHolder.getWriteInvoker().invoke(obj, new Object[]{null});
            return;
        }
        Class<?> clazz = fieldHolder.getFieldType();
        Class<?> clazz1 = value.getClass();
        if (clazz.getName().equals(clazz1.getName())) {
            fieldHolder.getWriteInvoker().invoke(obj, new Object[]{value});
        } else {
            Object newValue = Types.convert(value, clazz);
            fieldHolder.getWriteInvoker().invoke(obj, new Object[]{newValue});
        }
    }

    public static <T> void setObjectValueByFieldNameWithTypeChange(T obj, Map<String, Object> m, Boolean includeNull) throws Exception {
        Map<String, FieldHolder> filedMap = Bean.getBeanHolder(obj.getClass()).getFieldMap();
        Set<Map.Entry<String, Object>> entrySet = m.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String fieldName = entry.getKey();
            Object value = entry.getValue();
            FieldHolder fieldHolder = filedMap.get(fieldName);
            if (fieldHolder == null || fieldHolder.getWriteInvoker() == null || value == null && !includeNull.booleanValue()) continue;
            if (value == null) {
                fieldHolder.getWriteInvoker().invoke(obj, new Object[]{null});
                continue;
            }
            Class<?> clazz = fieldHolder.getFieldType();
            if (clazz == null) continue;
            Class<?> clazz1 = value.getClass();
            if (clazz.getName().equals(clazz1.getName())) {
                fieldHolder.getWriteInvoker().invoke(obj, new Object[]{entry.getValue()});
                continue;
            }
            Object newValue = Types.convert(value, clazz);
            fieldHolder.getWriteInvoker().invoke(obj, new Object[]{newValue});
        }
    }

    public static <T> void setObjectValueByFieldNameWithTypeChange(T obj, Map<String, Object> m) throws Exception {
        Bean.setObjectValueByFieldNameWithTypeChange(obj, m, true);
    }

    public static <T> void setObjectValueByFieldNameWithTypeChange(T obj, Map<String, Object> m, Boolean includeNull, String confsStr, Boolean other) throws Exception {
        String[] confs = null;
        confs = null == confsStr ? new String[]{} : ("".equalsIgnoreCase(confsStr) ? new String[]{} : confsStr.split(","));
        Map<String, Object> tmp = null;
        tmp = other != false ? m : new HashMap<String, Object>();
        for (int i = 0; i < confs.length; ++i) {
            String conf = confs[i];
            String objField = "";
            String toObjField = "";
            Object value = null;
            try {
                String[] txs = conf.split("->");
                objField = txs[0];
                toObjField = txs[1];
            }
            catch (Exception e) {
                throw new CommonException(confsStr + "\u8f6c\u6362\u6807\u8bc6\u7b26\u4e0d\u7b26\u5408\u683c\u5f0f");
            }
            if (StringUtility.isFunction(objField).booleanValue()) {
                String[] functionInfo = StringUtility.getFunctionInfo(objField);
                String functionNames = functionInfo[0];
                String[] propertys = functionInfo[1].split(",");
                if (propertys.length == 1) {
                    value = m.get(propertys[0]);
                    String className = functionNames.substring(0, functionNames.lastIndexOf("."));
                    String functionName = functionNames.substring(functionNames.lastIndexOf(".") + 1, functionNames.length());
                    Object[] ovalues = new Object[]{value};
                    try {
                        Class<?> clazz = Class.forName(className, true, Reflect.getClassLoader());
                        value = Function.invokeStaticMethod(clazz, functionName, ovalues);
                    }
                    catch (CommonException e) {
                        e.printStackTrace();
                        throw new CommonException(className + "." + functionName + "\u51fa\u9519");
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                        throw new CommonException(className + "." + functionName + "\u51fa\u9519");
                    }
                }
            } else {
                value = m.get(objField);
            }
            tmp.put(toObjField, value);
        }
        Bean.setObjectValueByFieldNameWithTypeChange(obj, tmp, includeNull);
    }

    @Deprecated
    public static <T> void setObjectValueByFieldNameWithTypeChange(T obj, Map<String, Object> m, String confsStr, Boolean other) throws Exception {
        Bean.setObjectValueByFieldNameWithTypeChange(obj, m, true, confsStr, other);
    }

    public static Class<?> getClassByName(String className) throws ClassNotFoundException {
        return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
    }

    public static <T> Object copyObjectToObject(T obj, T toObj, Boolean includeNull, String confsStr, Boolean other) throws Exception {
        Map<String, Object> m = Bean.getObjectValue(obj);
        Bean.setObjectValueByFieldNameWithTypeChange(toObj, m, includeNull, confsStr, other);
        return toObj;
    }

    public static <T> Object copyObjectToObject(T obj, T toObj, Boolean includeNull) throws Exception {
        Bean.copyObjectToObject(obj, toObj, includeNull, null, true);
        return toObj;
    }

    @Deprecated
    public static <T> Object copyObjectToObject(T obj, T toObj, String confsStr, Boolean other) throws Exception {
        Bean.copyObjectToObject(obj, toObj, true, confsStr, other);
        return toObj;
    }

    public static Boolean isExtends(Class<?> clazz, Class<?> criterionClazz) {
        if (clazz.getSuperclass() == null) {
            return false;
        }
        if (clazz.getSuperclass().equals(criterionClazz)) {
            return true;
        }
        return Bean.isExtends(clazz.getSuperclass(), criterionClazz);
    }

    public static Boolean isInstance(Class<?> clazz, Class<?> criterionClazz) {
        Class<?>[] clazzes = clazz.getInterfaces();
        if (clazzes == null || clazzes.length == 0) {
            return false;
        }
        boolean is = false;
        for (int i = 0; i < clazzes.length; ++i) {
            if (!clazzes[i].equals(criterionClazz) || !(is = true)) continue;
            return is;
        }
        for (Class<?> clazzInterface : clazzes) {
            is = Bean.isInstance(clazzInterface, criterionClazz);
            if (!is) continue;
            return is;
        }
        return is;
    }

    public static String arrayToString(Object[] array) {
        StringBuilder sb = new StringBuilder();
        sb.append("array:").append(" values [");
        for (int i = 0; i < array.length; ++i) {
            sb.append(Types.valueToString(array[i]));
            if (i >= array.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public static <T> Boolean hasField(Class<T> clazz, String fieldName) {
        Map<String, FieldHolder> filedMap = Bean.getBeanHolder(clazz).getPrivateFieldMap();
        FieldHolder fieldHolder = filedMap.get(fieldName);
        if (fieldHolder == null) {
            return false;
        }
        if (fieldHolder.getWriteInvoker() == null || fieldHolder.getReaderInvoker() == null) {
            return false;
        }
        return true;
    }

    public static <T> String toString(T t) {
        if (t.getClass().isArray()) {
            return Bean.arrayToString((Object[])t);
        }
        Map<String, Object> m = Bean.getObjectValue(t);
        StringBuilder sb = new StringBuilder();
        sb.append("class: ").append(t.getClass().getName()).append(" values [ ");
        for (Map.Entry<String, Object> e : m.entrySet()) {
            String value;
            if (e.getValue() == null) {
                value = "null";
            } else {
                try {
                    value = Types.valueToString(e.getValue());
                }
                catch (Exception exception) {
                    value = e.getValue().toString();
                }
            }
            sb.append(e.getKey()).append(" = ").append(value).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        return sb.toString();
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    static <T extends Annotation> void _getDeclaredMethods(Class<?> clz, List<Method> methodArray, Class<T> annotationClazz) {
        Method[] methods;
        for (Method method : methods = clz.getDeclaredMethods()) {
            if (annotationClazz == null) {
                methodArray.add(method);
                continue;
            }
            if (method.getAnnotation(annotationClazz) == null) continue;
            methodArray.add(method);
        }
        if (clz.getSuperclass() == null) {
            return;
        }
        Bean._getDeclaredMethods(clz.getSuperclass(), methodArray, annotationClazz);
    }

    static <T extends Annotation> void _getClassDeclaredMethods(Class<?> clz, List<Method> methodArray, Class<T> annotationClazz) {
        Method[] methods;
        for (Method method : methods = clz.getDeclaredMethods()) {
            if (annotationClazz == null) {
                methodArray.add(method);
                continue;
            }
            if (method.getAnnotation(annotationClazz) == null) continue;
            methodArray.add(method);
        }
        if (clz.getSuperclass() == null) {
            return;
        }
        Bean._getClassDeclaredMethods(clz.getSuperclass(), methodArray, annotationClazz);
    }

    static <T extends Annotation> void _getInterfaceDeclaredMethods(Class<?>[] clzArray, List<Method> methodArray, Class<T> annotationClazz) {
        for (Class<?> clz : clzArray) {
            Method[] methods;
            for (Method method : methods = clz.getDeclaredMethods()) {
                if (annotationClazz == null) {
                    methodArray.add(method);
                    continue;
                }
                if (method.getAnnotation(annotationClazz) == null) continue;
                methodArray.add(method);
            }
            if (clz.getInterfaces() == null) {
                return;
            }
            Bean._getInterfaceDeclaredMethods(clz.getInterfaces(), methodArray, annotationClazz);
        }
    }

    public static <T extends Annotation> Method[] getDeclaredMethods(Class<?> clz, Class<T> annotationClazz) {
        ArrayList<Method> methodArray = new ArrayList<Method>();
        if (clz.isInterface()) {
            Bean._getInterfaceDeclaredMethods(new Class[]{clz}, methodArray, annotationClazz);
        } else {
            Bean._getClassDeclaredMethods(clz, methodArray, annotationClazz);
        }
        return methodArray.toArray(new Method[methodArray.size()]);
    }
}

