/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.commons.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class HttpUtils {
    static ThreadLocal<CloseableHttpClient> threadLocal = new ThreadLocal();
    static CloseableHttpClient httpClient = null;
    static PoolingHttpClientConnectionManager pool = null;
    public static final String CHARSET_UTF_8 = "utf-8";

    public static CloseableHttpClient getHttpClient() {
        return httpClient;
    }

    public static HttpPost buildPostBodyRequest(String url, String body) throws UnsupportedEncodingException {
        HttpPost request = new HttpPost(url);
        request.setEntity((HttpEntity)new StringEntity(body, Charset.forName(CHARSET_UTF_8)));
        request.addHeader("Connection", "close");
        return request;
    }

    public static SSLContext createIgnoreVerifySSL() {
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSLv3");
            X509TrustManager trustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            sc.init(null, new TrustManager[]{trustManager}, null);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        return sc;
    }

    public static CloseableHttpResponse sendHttpPost(HttpPost httpPost) throws IOException {
        CloseableHttpClient closeableHttpClient = HttpUtils.getHttpClient();
        CloseableHttpResponse response = null;
        try {
            response = closeableHttpClient.execute((HttpUriRequest)httpPost);
        }
        catch (Exception e) {
            closeableHttpClient.close();
            threadLocal.remove();
            throw e;
        }
        return response;
    }

    public static String sendHttpGet(HttpGet httpGet) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        String responseContent = null;
        try {
            httpClient = HttpClients.createDefault();
            response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            if (response.getStatusLine().getStatusCode() >= 300) {
                responseContent = EntityUtils.toString((HttpEntity)entity, (String)CHARSET_UTF_8);
                EntityUtils.consume((HttpEntity)entity);
                throw new Exception("HTTP Request is not success, Response code is " + response.getStatusLine().getStatusCode() + ", error:" + responseContent);
            }
            if (200 == response.getStatusLine().getStatusCode()) {
                responseContent = EntityUtils.toString((HttpEntity)entity, (String)CHARSET_UTF_8);
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return responseContent;
    }

    static {
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)new SSLConnectionSocketFactory(HttpUtils.createIgnoreVerifySSL())).build();
        pool = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        pool.setMaxTotal(1000);
        pool.setDefaultMaxPerRoute(1000);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(30000).setConnectionRequestTimeout(120000).build();
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)pool).setDefaultRequestConfig(requestConfig).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(2, true)).build();
        new Thread(() -> {
            while (true) {
                pool.closeIdleConnections(20000L, TimeUnit.MILLISECONDS);
                pool.closeExpiredConnections();
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }).start();
    }
}

