/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.spatial.wkt;

import com.northpool.spatial.AGeomDecoder;
import com.northpool.spatial.Constants;
import com.northpool.spatial.GeomDecoder;
import com.northpool.spatial.geofeature.GeoBuffer;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;

@AGeomDecoder(type=Constants.SPATIAL_TYPE.wkt)
public class WktDecoder
implements GeomDecoder<String> {
    public static final WktDecoder DECODER = new WktDecoder();

    @Override
    public GeoBuffer toGeoBuffer(String wellKnownText) throws Exception {
        int SRID = -1;
        if (wellKnownText.startsWith("SRID=")) {
            String[] wkt = StringUtils.split((String)wellKnownText, (String)";");
            SRID = Integer.valueOf(wkt[0].substring(5, wkt[0].length()));
            wellKnownText = wkt[1];
        }
        WKTReader reader = new WKTReader();
        Geometry geometry = reader.read(wellKnownText);
        if (SRID != -1) {
            geometry.setSRID(SRID);
        }
        GeoBuffer geoBuffer = GeoBuffer.fromJTSGeometry(geometry);
        return geoBuffer;
    }

    public static void main(String[] aaa) throws Exception {
        String aaaa = "SRID=4610;MULTIPOLYGON (((114.41819694029857 34.930169792612276, 114.4177192113815 34.92882014495166, 114.41752003813087 34.928949586430406, 114.41793160918917 34.9301985080225, 114.41819694029857 34.930169792612276)))";
        GeoBuffer geoBuffer = DECODER.toGeoBuffer(aaaa);
        System.out.println(geoBuffer);
    }
}

