/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.spatial.grid.impl.quadtreegrid;

import com.northpool.spatial.grid.Constants;
import com.northpool.spatial.grid.impl.GridName;
import com.northpool.spatial.grid.impl.QuadtreeImpl;

@GridName(name="esri_degree_base256")
public class EsriDegree256
extends QuadtreeImpl {
    double[] resolution;

    public EsriDegree256() {
        this.init(256, 1, Constants.GRID_UNIT.degree);
    }

    public EsriDegree256(int minX, int maxY, double[] resolution) {
        this.init(256, 1, Constants.GRID_UNIT.degree);
    }

    @Override
    protected void init(Integer base, int beginLevel, Constants.GRID_UNIT unit) {
        this.base = base;
        this.unit = unit;
        this.minX = -400.0;
        this.minY = -90.0;
        this.maxX = 180.0;
        this.maxY = 400.0;
        this.beginLevel = beginLevel;
    }

    @Override
    public Double getResolution(int level) {
        if (level >= this.resolution.length || level < 0) {
            return this.resolution[0] / Math.pow(2.0, level);
        }
        return this.resolution[level];
    }

    @Override
    public void setResolutions(double[] resolution) {
        this.resolution = resolution;
    }

    @Override
    public double[] getResolutions() {
        return this.resolution;
    }

    public static void main(String[] aaa) {
        EsriDegree256 tdtDegree256 = new EsriDegree256();
        System.out.print(tdtDegree256.getExtentByXY(17, 75.75, 36.0));
    }
}

