/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.spatial.shape;

import com.northpool.commons.util.DoubleBuilder;
import com.northpool.spatial.AGeomEncoder;
import com.northpool.spatial.Constants;
import com.northpool.spatial.GeomEncoder;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.spatial.geofeature.GeoPart;
import com.northpool.spatial.shape.ShapeType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@AGeomEncoder(type=Constants.SPATIAL_TYPE.shape)
public class ShapeEncoder
implements GeomEncoder<byte[]> {
    public static final ShapeEncoder ENCODER = new ShapeEncoder();

    public ByteBuffer byteBufferFromGeoBuffer(GeoBuffer geoBuffer, ByteOrder byteOrder) {
        ByteBuffer shapeBuffer;
        if (geoBuffer == null) {
            return this.getEmptyShape();
        }
        Constants.GEO_TYPE geotype = geoBuffer.getGeoType();
        switch (geotype) {
            case POINT: {
                shapeBuffer = this.processPoint(geoBuffer, byteOrder);
                break;
            }
            case LINESTRING: {
                shapeBuffer = this.processMultiPath(geoBuffer, byteOrder);
                break;
            }
            case POLYGON: {
                shapeBuffer = this.processMultiPath(geoBuffer, byteOrder);
                break;
            }
            case MULTILINESTRING: {
                shapeBuffer = this.processMultiPath(geoBuffer, byteOrder);
                break;
            }
            case MULTIPOLYGON: {
                shapeBuffer = this.processMultiPath(geoBuffer, byteOrder);
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u51e0\u4f55\u7c7b\u578b\uff1a" + geotype.name());
            }
        }
        return shapeBuffer;
    }

    private ByteBuffer allocate(int size, ByteOrder byteOrder) {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.order(byteOrder);
        return buffer;
    }

    private ByteBuffer processMultiPath(GeoBuffer geoBuffer, ByteOrder byteOrder) {
        double yEnd;
        double xEnd;
        double yBegin;
        DoubleBuilder doubleBuilder;
        int ipart;
        int dimension = geoBuffer.getDimension();
        boolean bExportZ = geoBuffer.getDimension() != 2;
        boolean bExportM = false;
        boolean bExportID = false;
        boolean bPolygon = false;
        boolean bHasCurves = false;
        if (geoBuffer.getGeoType() == Constants.GEO_TYPE.LINESTRING || geoBuffer.getGeoType() == Constants.GEO_TYPE.MULTILINESTRING) {
            bPolygon = false;
        } else if (geoBuffer.getGeoType() == Constants.GEO_TYPE.POLYGON || geoBuffer.getGeoType() == Constants.GEO_TYPE.MULTIPOLYGON) {
            bPolygon = true;
        } else {
            throw new RuntimeException("\u4e0d\u662fLINESTRING\u6216\u8005\u662fPOLYGON\u7c7b\u578b");
        }
        int partCount = geoBuffer.getPartSize();
        int pointCount = geoBuffer.getCoordinateCount();
        if (!bPolygon) {
            // empty if block
        }
        int size = 44 + partCount * 4 + pointCount * 2 * 8;
        if (bExportZ) {
            size += 16 + pointCount * 8;
        }
        if (bExportM) {
            size += 16 + pointCount * 8;
        }
        if (bExportID) {
            size += pointCount * 4;
        }
        if (bHasCurves) {
            // empty if block
        }
        ByteBuffer shapeBuffer = this.allocate(size, byteOrder);
        ShapeType shapeType = bExportZ ? (bPolygon ? ShapeType.POLYGONZ : ShapeType.POLYLINEZ) : (bPolygon ? ShapeType.POLYGON : ShapeType.POLYLINE);
        int offset = 0;
        shapeBuffer.putInt(offset, shapeType.id);
        double[] bbox = geoBuffer.getBBOX();
        shapeBuffer.putDouble(offset += 4, bbox[0]);
        shapeBuffer.putDouble(offset += 8, bbox[1]);
        shapeBuffer.putDouble(offset += 8, bbox[2]);
        shapeBuffer.putDouble(offset += 8, bbox[3]);
        shapeBuffer.putInt(offset += 8, partCount);
        shapeBuffer.putInt(offset += 4, pointCount);
        offset += 4;
        int pointIndexDelta = 0;
        int partOffset = 0;
        for (ipart = 0; ipart < partCount; ++ipart) {
            int istart = partOffset + pointIndexDelta;
            shapeBuffer.putInt(offset, istart);
            offset += 4;
            partOffset += geoBuffer.getPart(ipart).getCoordinateCount();
        }
        if (pointCount > 0) {
            for (ipart = 0; ipart < partCount; ++ipart) {
                GeoPart geoPart = geoBuffer.getPart(ipart);
                doubleBuilder = geoPart.getDoubleBuilder();
                if (bPolygon) {
                    GeoPart.RING_TYPE ringType = geoPart.getRingType();
                    boolean isCCW = GeoBuffer.isCCW(doubleBuilder, dimension);
                    if (isCCW) {
                        if (ringType == GeoPart.RING_TYPE.outside) {
                            doubleBuilder = GeoBuffer.reverseCoordinates(doubleBuilder, dimension);
                        }
                    } else if (ringType == GeoPart.RING_TYPE.inside) {
                        doubleBuilder = GeoBuffer.reverseCoordinates(doubleBuilder, dimension);
                    }
                }
                for (int i = 0; i < doubleBuilder.size() / dimension; ++i) {
                    double x = doubleBuilder.get(i * dimension);
                    double y = doubleBuilder.get(i * dimension + 1);
                    shapeBuffer.putDouble(offset, x);
                    shapeBuffer.putDouble(offset += 8, y);
                    offset += 8;
                }
                if (!bPolygon) continue;
                double xBegin = doubleBuilder.get(0);
                yBegin = doubleBuilder.get(1);
                xEnd = doubleBuilder.get(doubleBuilder.size() - geoBuffer.getDimension());
                yEnd = doubleBuilder.get(doubleBuilder.size() - geoBuffer.getDimension() + 1);
                if (xBegin == xEnd && yBegin == yEnd) continue;
                shapeBuffer.putDouble(offset, xBegin);
                shapeBuffer.putDouble(offset += 8, yBegin);
                offset += 8;
            }
        }
        if (bExportZ) {
            double[] zInterval = geoBuffer.zInterval();
            shapeBuffer.putDouble(offset, zInterval[0]);
            shapeBuffer.putDouble(offset += 8, zInterval[1]);
            offset += 8;
            if (pointCount > 0) {
                for (int ipart2 = 0; ipart2 < partCount; ++ipart2) {
                    doubleBuilder = geoBuffer.getPart(ipart2).getDoubleBuilder();
                    for (int i = 0; i < doubleBuilder.size() / dimension; ++i) {
                        double z = doubleBuilder.get(i * dimension + 2);
                        shapeBuffer.putDouble(offset, z);
                        offset += 8;
                    }
                    if (!bPolygon) continue;
                    double xBegin = doubleBuilder.get(0);
                    yBegin = doubleBuilder.get(1);
                    xEnd = doubleBuilder.get(doubleBuilder.size() - dimension);
                    yEnd = doubleBuilder.get(doubleBuilder.size() - dimension + 1);
                    if (xBegin == xEnd && yBegin == yEnd) continue;
                    double z = doubleBuilder.get(2);
                    shapeBuffer.putDouble(offset, z);
                    offset += 8;
                }
            }
        }
        return shapeBuffer;
    }

    private ByteBuffer processPoint(GeoBuffer geoBuffer, ByteOrder byteOrder) {
        boolean bExportZ = geoBuffer.getDimension() != 2;
        boolean bExportM = false;
        boolean bExportID = false;
        int size = 20;
        if (bExportZ) {
            size += 8;
        }
        if (bExportM) {
            size += 8;
        }
        if (bExportID) {
            size += 4;
        }
        ByteBuffer shapeBuffer = this.allocate(size, byteOrder);
        ShapeType shapeType = bExportZ ? ShapeType.POINTZ : ShapeType.POINT;
        int offset = 0;
        shapeBuffer.putInt(offset, shapeType.id);
        shapeBuffer.putDouble(offset += 4, geoBuffer.getX());
        shapeBuffer.putDouble(offset += 8, geoBuffer.getY());
        offset += 8;
        if (bExportZ) {
            shapeBuffer.putDouble(offset, geoBuffer.getZ());
            offset += 8;
        }
        return shapeBuffer;
    }

    ByteBuffer getEmptyShape() {
        ByteBuffer shapeBuffer = ByteBuffer.allocate(4);
        shapeBuffer.putInt(0, ShapeType.NULL.id);
        return shapeBuffer;
    }

    public static ShapeType is(Constants.GEO_TYPE geoType) {
        switch (geoType) {
            case POINT: {
                return ShapeType.POINT;
            }
            case LINESTRING: {
                return ShapeType.POLYLINE;
            }
            case POLYGON: {
                return ShapeType.POLYGON;
            }
            case MULTIPOINT: {
                return ShapeType.MULTIPOINT;
            }
            case MULTILINESTRING: {
                return ShapeType.POLYLINE;
            }
            case MULTIPOLYGON: {
                return ShapeType.POLYGON;
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u51e0\u4f55\u7c7b\u578b\uff1a" + geoType.name());
    }

    @Override
    public byte[] fromGeoBuffer(GeoBuffer geoBuffer) {
        ByteBuffer byteBuffer = this.byteBufferFromGeoBuffer(geoBuffer, ByteOrder.LITTLE_ENDIAN);
        int len = byteBuffer.limit() - byteBuffer.position();
        byte[] bytes = new byte[len];
        byteBuffer.get(bytes);
        return bytes;
    }

    @Override
    public byte[] fromGeoBuffer(GeoBuffer geoBuffer, boolean includeSrid, ByteOrder byteOrder) {
        ByteBuffer byteBuffer = this.byteBufferFromGeoBuffer(geoBuffer, byteOrder);
        int len = byteBuffer.limit() - byteBuffer.position();
        byte[] bytes = new byte[len];
        byteBuffer.get(bytes);
        return bytes;
    }
}

