/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.spatial.grid.impl.quadtreegrid;

import com.northpool.spatial.grid.Constants;
import com.northpool.spatial.grid.extent.GridExtent;
import com.northpool.spatial.grid.impl.GridName;
import com.northpool.spatial.grid.impl.QuadtreeImpl;

@GridName(name="gvtile_meter_base512")
public class GVTileMeter512
extends QuadtreeImpl {
    public static final Integer BASE_SIZE = 512;
    public static Double DEFAULT_LEFT = 0.0;
    public static Double DEFAULT_BOTTOM = 0.0;
    public static Double DEFAULT_TOP = 9900000.0;
    public static Double DEFAULT_RIGHT = 4.6E7;
    private double[] resolutionArray;

    public GVTileMeter512() {
        this.init(BASE_SIZE, 1, Constants.GRID_UNIT.meter);
    }

    public GVTileMeter512(double minX, double maxY, double topLevelResolution) {
        this.init(BASE_SIZE, 0, Constants.GRID_UNIT.meter);
        this.minX = minX;
        this.maxY = maxY;
        this.resolutionLevelBegin = topLevelResolution;
        this.resetBounds();
    }

    public GVTileMeter512(GridExtent extent) {
        this(extent.getLeft(), extent.getTop(), extent.getRight(), extent.getBottom());
    }

    public GVTileMeter512(double left, double top, double right, double bottom) {
        if (right <= left || bottom >= top) {
            throw new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684\u56db\u81f3\u8303\u56f4");
        }
        this.init(BASE_SIZE, 0, Constants.GRID_UNIT.meter);
        this.minX = left;
        this.maxY = top;
        this.maxX = right;
        this.minY = bottom;
        double extentSpan = Math.max(this.maxX - this.minX, this.maxY - this.minY);
        this.resolutionLevelBegin = extentSpan / (double)this.base;
    }

    @Override
    protected void init(Integer base, int beginLevel, Constants.GRID_UNIT unit) {
        this.base = base;
        this.unit = unit;
        this.beginLevel = beginLevel;
        this.maxLevel = this.MAX_TILE_LEVEL;
        this.minX = DEFAULT_LEFT;
        this.minY = DEFAULT_BOTTOM;
        this.maxX = DEFAULT_RIGHT;
        this.maxY = DEFAULT_TOP;
        double extentSpan = Math.max(this.maxX - this.minX, this.maxY - this.minY);
        this.resolutionLevelBegin = extentSpan / (double)this.base;
    }

    @Override
    public void setResolutions(double[] resolutions) {
        double topResolution;
        if (null == resolutions || resolutions.length < this.beginLevel + 1) {
            return;
        }
        this.resolutionArray = resolutions;
        this.resolutionLevelBegin = topResolution = resolutions[this.beginLevel];
        this.resetBounds();
    }

    @Override
    public double[] getResolutions() {
        if (null != this.resolutionArray && this.resolutionArray.length > 3) {
            return this.resolutionArray;
        }
        double topResolution = this.resolutionLevelBegin;
        int levels = this.maxLevel;
        double[] resoArray = new double[levels + 1];
        for (int i = 0; i <= levels; ++i) {
            resoArray[i] = topResolution / Math.pow(2.0, i - this.beginLevel);
        }
        return resoArray;
    }

    @Override
    public Double getResolution(int level) {
        if (null != this.resolutionArray && level < this.resolutionArray.length && level >= 0) {
            return this.resolutionArray[level];
        }
        return this.resolutionLevelBegin / Math.pow(2.0, level - this.beginLevel);
    }

    protected void resetBounds() {
        double tileSpan = (double)this.base * this.resolutionLevelBegin;
        this.maxX = this.minX + tileSpan;
        this.minY = this.maxY - tileSpan;
    }
}

