/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.commons.pipeline;

import com.northpool.commons.pipeline.AbstractHandler;
import com.northpool.commons.pipeline.Handler;
import com.northpool.commons.reflect.Bean;
import java.util.concurrent.atomic.AtomicReference;

public class Pipeline
implements AutoCloseable {
    private Handler head;
    private Handler tail;
    volatile boolean errorOccurred = false;
    private AtomicReference<RuntimeException> _exception = new AtomicReference<Object>(null);

    public Pipeline() {
        HeadHandler headHandler = new HeadHandler();
        this.head = headHandler;
        this.tail = headHandler;
    }

    public RuntimeException getException() {
        return this._exception.get();
    }

    public Pipeline pip(Handler handler) {
        if (!Bean.isExtends(handler.getClass(), AbstractHandler.class).booleanValue()) {
            throw new RuntimeException("handler\u5fc5\u987b\u7ee7\u627fAbstractHandler");
        }
        AbstractHandler abstractHandler = (AbstractHandler)handler;
        abstractHandler.setExecutePipeline(this);
        this.tail.setNext(handler);
        this.tail = handler;
        return this;
    }

    public void exceptionOccurr(RuntimeException e) {
        this.errorOccurred = true;
        this._exception.compareAndSet(null, e);
    }

    public boolean isErrorOccurred() {
        return this.errorOccurred;
    }

    public void end() throws Exception {
        this.head.end();
    }

    public <T> void push(T data) throws Exception {
        this.head.pushData(data);
    }

    @Override
    public void close() throws Exception {
        Handler handler = this.head;
        while (true) {
            handler.close();
            if (handler.next() == null) break;
            handler = handler.next();
        }
    }

    final class HeadHandler
    extends AbstractHandler
    implements Handler {
        HeadHandler() {
        }

        @Override
        public <T> void pushData(T data) throws Exception {
            if (this.next != null) {
                this.next.pushData(data);
            }
        }

        @Override
        public void end() throws Exception {
            if (this.next != null) {
                this.next.end();
            }
        }

        @Override
        public void close() throws Exception {
        }
    }
}

