/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.pixel.resmple;

import com.northpool.pixel.resmple.Fn1DResamplingFunction;
import java.nio.ByteBuffer;

public class NearestNeighbour
implements Fn1DResamplingFunction {
    public static final NearestNeighbour INSTANCE = new NearestNeighbour();

    @Override
    public void resampling(ByteBuffer dstBuffer, int dstInitialOffset, int numDstPixels, int dstPixelStride, ByteBuffer srcBuffer, int srcInitialOffset, int numSrcPixels, int srcPixelStride, int numBytesPerPixel) {
        int accumulator = 0;
        for (int dstPixelIndex = 0; dstPixelIndex < numDstPixels; ++dstPixelIndex) {
            int srcPixelIndex = accumulator / numDstPixels * srcPixelStride + srcInitialOffset;
            switch (numBytesPerPixel) {
                case 4: {
                    dstBuffer.put(dstInitialOffset + 3, srcBuffer.get(srcPixelIndex + 3));
                }
                case 3: {
                    dstBuffer.put(dstInitialOffset + 2, srcBuffer.get(srcPixelIndex + 2));
                    dstBuffer.put(dstInitialOffset + 1, srcBuffer.get(srcPixelIndex + 1));
                }
                case 1: {
                    dstBuffer.put(dstInitialOffset, srcBuffer.get(srcPixelIndex));
                }
            }
            dstInitialOffset += dstPixelStride;
            accumulator += numSrcPixels;
        }
    }
}

