/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.spatial.shape;

public final class ShapeType {
    public static final ShapeType NULL = new ShapeType(0, "Null", false);
    public static final ShapeType POINT = new ShapeType(1, "Point", false);
    public static final ShapeType POINTZ = new ShapeType(11, "PointZ", true);
    public static final ShapeType POINTM = new ShapeType(21, "PointM", false);
    public static final ShapeType POLYLINE = new ShapeType(3, "Polyline", false);
    public static final ShapeType POLYLINEZ = new ShapeType(13, "PolylineZ", true);
    public static final ShapeType POLYLINEM = new ShapeType(23, "PolylineM", false);
    public static final ShapeType POLYGON = new ShapeType(5, "Polygon", false);
    public static final ShapeType POLYGONZ = new ShapeType(15, "PolygonZ", true);
    public static final ShapeType POLYGONM = new ShapeType(25, "PolygonM", false);
    public static final ShapeType MULTIPOINT = new ShapeType(8, "MultiPoint", false);
    public static final ShapeType MULTIPOINTZ = new ShapeType(18, "MultiPointZ", true);
    public static final ShapeType MULTIPOINTM = new ShapeType(28, "MultiPointM", false);
    public static final ShapeType UNDEFINED = new ShapeType(-1, "Undefined", false);
    public final int id;
    public final String name;
    private boolean hasZ = false;
    private boolean hasM = false;

    public boolean isHasZ() {
        return this.hasZ;
    }

    protected ShapeType(int id, String name, boolean hasZ) {
        this.id = id;
        this.name = name;
        this.hasZ = hasZ;
    }

    public String toString() {
        return this.name;
    }

    public boolean isMultiPoint() {
        boolean mp = true;
        if (this == UNDEFINED) {
            mp = false;
        } else if (this == NULL) {
            mp = false;
        } else if (this == POINT || this == POINTM || this == POINTZ) {
            mp = false;
        }
        return mp;
    }

    public boolean isPointType() {
        return this.id % 10 == 1;
    }

    public boolean isLineType() {
        return this.id % 10 == 3;
    }

    public boolean isPolygonType() {
        return this.id % 10 == 5;
    }

    public boolean isMultiPointType() {
        return this.id % 10 == 8;
    }

    public static ShapeType forID(int id) {
        ShapeType t;
        switch (id) {
            case 0: {
                t = NULL;
                break;
            }
            case 1: {
                t = POINT;
                break;
            }
            case 11: {
                t = POINTZ;
                break;
            }
            case 21: {
                t = POINTM;
                break;
            }
            case 3: {
                t = POLYLINE;
                break;
            }
            case 13: {
                t = POLYLINEZ;
                break;
            }
            case 23: {
                t = POLYLINEM;
                break;
            }
            case 5: {
                t = POLYGON;
                break;
            }
            case 15: {
                t = POLYGONZ;
                break;
            }
            case 25: {
                t = POLYGONM;
                break;
            }
            case 8: {
                t = MULTIPOINT;
                break;
            }
            case 18: {
                t = MULTIPOINTZ;
                break;
            }
            case 28: {
                t = MULTIPOINTM;
                break;
            }
            default: {
                t = UNDEFINED;
            }
        }
        return t;
    }
}

