/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.commons.classloader;

import com.northpool.commons.classloader.MemoryJar;
import com.northpool.commons.classloader.MemoryURLConnection;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class MemoryClassLoader
extends ClassLoader {
    protected HashMap<String, MemoryJar> jarMap = new HashMap();
    protected HashMap<String, ByteBuffer> resourceMap = new HashMap();

    public MemoryClassLoader() {
        this.init();
    }

    public void init() {
        try {
            Field f = ClassLoader.class.getDeclaredField("parent");
            f.setAccessible(true);
            ClassLoader parent = (ClassLoader)f.get(this);
            ClassLoader parentparent = (ClassLoader)f.get(parent);
            InnerClassLoader l = new InnerClassLoader(new URL[0], parentparent, this);
            f.set(parent, l);
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public MemoryClassLoader(ClassLoader parent) {
        super(parent);
    }

    protected TYPE isType(String path) {
        if (path.indexOf(":") != -1) {
            return TYPE.urlPath;
        }
        return TYPE.classPath;
    }

    protected byte[] findClassByte(String uri) throws IOException {
        ByteBuffer buffer = this.resourceMap.get(uri);
        if (buffer == null) {
            return null;
        }
        return this.getBytes(buffer);
    }

    private byte[] getBytes(ByteBuffer buffer) {
        buffer.flip();
        int length = buffer.limit() - buffer.position();
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        return bytes;
    }

    protected InputStream findClassInputStream(String uri) throws IOException {
        byte[] b = this.findClassByte(uri);
        if (b == null) {
            return null;
        }
        return new ByteArrayInputStream(b);
    }

    public InputStream getClassAsStream(String url) {
        if (this.resourceMap.get(url) != null) {
            try {
                InputStream is = this.findClassInputStream(url);
                return is;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public synchronized void loadJar(String jarName, byte[] jarByte) throws IOException {
        if (this.jarMap.containsKey(jarName)) {
            throw new RuntimeException("\u5df2\u7ecf\u6ce8\u518c\u8fc7jar:" + jarName);
        }
        MemoryJar memoryJar = new MemoryJar(jarName, jarByte);
        HashMap<String, ByteBuffer> jarClassMap = memoryJar.getAllResources();
        for (Map.Entry<String, ByteBuffer> entry : jarClassMap.entrySet()) {
        }
        this.resourceMap.putAll(memoryJar.getAllResources());
    }

    private Class<?> findClassInMemory(String className) throws ClassNotFoundException {
        String mark_name = className.replace(".", "/");
        Class<?> clazz = this.findClass(className);
        if (clazz != null) {
            return clazz;
        }
        mark_name = mark_name + ".class";
        byte[] classByte = null;
        try {
            classByte = this.findClassByte(mark_name);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(className);
        }
        if (classByte == null) {
            return null;
        }
        Class<?> c = this.defineClass(className, classByte, 0, classByte.length);
        return c;
    }

    public Class<?> findLoadedClassByName(String name) {
        return this.findLoadedClass(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> clazz = this.findClass(name);
            if (clazz == null) {
                return this.getParent().loadClass(name);
            }
            return clazz;
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        String mark_name = name.replace(".", "/");
        mark_name = mark_name + ".class";
        byte[] classByte = null;
        try {
            classByte = this.findClassByte(mark_name);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name);
        }
        if (classByte == null) {
            return null;
        }
        c = this.defineClass(name, classByte, 0, classByte.length);
        return c;
    }

    @Override
    protected URL findResource(String name) {
        ByteBuffer buffer = this.resourceMap.get(name);
        if (buffer == null) {
            return null;
        }
        return this.createURI(name, buffer);
    }

    private URL createURI(final String resourceName, final ByteBuffer buffer) {
        try {
            URL url1 = new URL(null, "memory:" + resourceName, new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    return new MemoryURLConnection(null, resourceName, buffer);
                }
            });
            return url1;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static String createURIPath(String entryName) {
        String path = entryName.replace("\\", "/");
        return path;
    }

    public synchronized void registerClass(String className, byte[] bytes) {
        className = className.replace(".", "/");
        className = className + ".class";
        String uri = MemoryClassLoader.createURIPath(className);
        ByteBuffer buff = ByteBuffer.allocateDirect(bytes.length);
        buff.put(bytes);
        this.resourceMap.put(uri, buff);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ArrayList resourcesList = new ArrayList();
        this.resourceMap.entrySet().stream().forEach(entry -> {
            String resourceName = (String)entry.getKey();
            ByteBuffer buffer = (ByteBuffer)entry.getValue();
            if (resourceName.startsWith(name)) {
                resourcesList.add(this.createURI(resourceName, buffer));
            }
        });
        final URL[] arr = (URL[])resourcesList.stream().toArray(URL[]::new);
        Enumeration<URL> en = new Enumeration<URL>(){
            private int current = 0;

            @Override
            public boolean hasMoreElements() {
                return this.current != arr.length;
            }

            @Override
            public URL nextElement() {
                URL url = arr[this.current];
                ++this.current;
                return url;
            }
        };
        return en;
    }

    class InnerClassLoader
    extends URLClassLoader {
        protected MemoryClassLoader classLoader;
        protected HashMap<String, ByteBuffer> resourceMap;

        public InnerClassLoader(URL[] urls, ClassLoader parent, MemoryClassLoader classLoader) {
            super(urls, parent);
            this.resourceMap = new HashMap();
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            Class c = null;
            c = this.classLoader.findClassInMemory(name);
            return c;
        }
    }

    private static enum TYPE {
        classPath,
        urlPath;

    }
}

