/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.commons.filechannel;

import com.concurrentli.EpochEvent;
import com.concurrentli.FutureEpochEvent;
import com.northpool.commons.filechannel.FileInfo;
import com.northpool.commons.filechannel.SplitFilePart;
import com.northpool.commons.util.FileUtil;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.util.concurrent.LinkedBlockingQueue;
import sun.nio.ch.DirectBuffer;

public class FileChannelWriter
implements AutoCloseable {
    private String fileName;
    private int buffsize;
    private ByteBuffer currentWriterBuffer;
    private FileChannel currentWriterChannel;
    private RandomAccessFile currentRandomAccessFile;
    private long splitSize = -1L;
    private boolean split = false;
    private boolean md5 = false;
    private LinkedBlockingQueue<byte[]> md5BlockLink;
    private long fileSize = 0L;
    private long currentOffset = 0L;
    private int filePathIndex = 0;
    private final EpochEvent epoch = new FutureEpochEvent(0L);
    private FileInfo fileInfo;
    private SplitFilePart currentSplitFilePart;
    private byte[] md5Block;

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public FileChannelWriter(String fileName, Integer buffsize) throws IOException {
        this.fileName = fileName;
        this.buffsize = buffsize;
        if (this.splitSize > 0L) {
            this.split = true;
        }
    }

    public FileChannelWriter md5(Boolean md5) {
        this.md5 = md5;
        this.md5Block = new byte[262144];
        this.md5BlockLink = new LinkedBlockingQueue();
        return this;
    }

    public FileChannelWriter setSplitSize(long splitSize) {
        this.splitSize = splitSize;
        this.split = true;
        return this;
    }

    public FileChannelWriter build() throws IOException {
        this.fileInfo = new FileInfo();
        this.fileInfo.setFileName(Paths.get(this.fileName, new String[0]).getFileName().toString());
        String pathName = null;
        pathName = this.split ? this.createPathName() : this.fileName;
        this.createFileMappingBuffer(pathName);
        return this;
    }

    private String createPathName() {
        return this.fileName + "." + this.filePathIndex + ".tmp";
    }

    private void createFileMappingBuffer(String pathName) throws IOException {
        this.currentRandomAccessFile = new RandomAccessFile(pathName, "rw");
        this.currentWriterChannel = this.currentRandomAccessFile.getChannel();
        this.currentWriterBuffer = ByteBuffer.allocateDirect(this.buffsize);
        this.currentOffset = 0L;
        if (this.split) {
            SplitFilePart splitFilePart = new SplitFilePart();
            splitFilePart.setIndex(this.filePathIndex);
            splitFilePart.setFileName(Paths.get(pathName, new String[0]).getFileName().toString());
            this.currentSplitFilePart = splitFilePart;
        }
    }

    private String createInfoName() {
        return this.fileName + "_info.json";
    }

    public void end() throws IOException, InterruptedException {
        if (this.split) {
            this.endPart();
        } else {
            this.closeFileFileChannel();
        }
        this.fileInfo.setFileSize(this.fileSize);
        if (this.md5) {
            this.fileInfo.buildMD5();
            FileUtil.byte2File(this.fileInfo.toJson().getBytes("utf-8"), this.createInfoName());
        }
    }

    private void putMD5BlockData(byte[] block) {
    }

    private void endPart() throws IOException {
        this.closeFileFileChannel();
        this.currentSplitFilePart.setPartSize(this.currentOffset);
        this.fileInfo.getPart().add(this.currentSplitFilePart);
    }

    private void closeFileFileChannel() throws IOException {
        try {
            this.currentWriterBuffer.flip();
            this.currentWriterChannel.write(this.currentWriterBuffer);
            this.clean(this.currentWriterBuffer);
            this.currentWriterChannel.close();
            this.currentRandomAccessFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException();
        }
    }

    private void clean(ByteBuffer byteBuffer) {
        if (byteBuffer.isDirect()) {
            DirectBuffer db = (DirectBuffer)((Object)byteBuffer);
            db.cleaner().clean();
        }
    }

    private void putIntoBuffer(byte[] bytes, int offset, int length) {
        this.currentWriterBuffer.put(bytes, offset, length);
        this.currentOffset += (long)length;
        if (this.md5) {
            this.fileInfo.putMD5Data(bytes, offset, length);
            if (this.split) {
                this.currentSplitFilePart.putMD5Data(bytes, offset, length);
            }
        }
    }

    private synchronized void putSynchronized(byte[] bytes, int offset, int length) throws IOException, InterruptedException {
        int bytesLength = length;
        if (this.currentWriterBuffer.remaining() < bytesLength) {
            this.currentWriterBuffer.flip();
            this.currentWriterChannel.write(this.currentWriterBuffer);
            this.currentWriterBuffer.compact();
        }
        if (this.split) {
            if (this.currentOffset + (long)bytesLength > this.splitSize) {
                int fristPart = (int)(this.splitSize - this.currentOffset);
                if (fristPart == 0) {
                    this.endPart();
                    ++this.filePathIndex;
                    this.createFileMappingBuffer(this.createPathName());
                    this.putIntoBuffer(bytes, offset, bytesLength);
                } else {
                    this.putIntoBuffer(bytes, offset, fristPart);
                    this.endPart();
                    ++this.filePathIndex;
                    this.createFileMappingBuffer(this.createPathName());
                    this.putIntoBuffer(bytes, fristPart, bytesLength - fristPart);
                }
            } else {
                this.putIntoBuffer(bytes, offset, bytesLength);
            }
        } else {
            this.putIntoBuffer(bytes, offset, bytesLength);
        }
        this.fileSize += (long)bytesLength;
    }

    public void write(byte[] bytes, int offset, int length) throws IOException, InterruptedException {
        long sizeBytes = bytes.length;
        if (sizeBytes > (long)this.buffsize) {
            throw new IOException("\u8f93\u5165\u7684bytes\u5927\u5c0f\u4e0d\u80fd\u5927\u4e8e\u7f13\u5b58\u5927\u5c0f:" + this.buffsize);
        }
        this.putSynchronized(bytes, offset, length);
    }

    public void write(byte[] bytes) throws IOException, InterruptedException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void close() throws Exception {
        if (this.currentWriterChannel != null) {
            this.currentWriterChannel.close();
            this.currentRandomAccessFile.close();
        }
    }
}

