/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.commons.pipeline;

import com.northpool.commons.filechannel.FileChannelWriter;
import com.northpool.commons.filechannel.FileInfo;
import com.northpool.commons.pipeline.AbstractHandler;
import com.northpool.commons.pipeline.Handler;
import java.io.IOException;

public class FileHandler
extends AbstractHandler
implements Handler,
AutoCloseable {
    private String path;
    private FileChannelWriter writer;

    public FileHandler(String path, Integer buffSize, Boolean md5, Integer splitSize) throws IOException {
        this.path = path;
        if (buffSize == null) {
            buffSize = 0x100000;
        }
        if (md5 == null) {
            md5 = false;
        }
        this.writer = new FileChannelWriter(this.path, buffSize).md5(md5);
        if (splitSize != null) {
            this.writer.setSplitSize(splitSize.intValue());
        }
        this.writer.build();
    }

    @Override
    public void end() throws Exception {
        this.writer.end();
        if (this.next != null) {
            this.next.end();
        }
    }

    @Override
    public <T> void pushData(T data) throws Exception {
        this.writer.write((byte[])data);
        if (this.next != null) {
            this.next.pushData(data);
        }
    }

    @Override
    public void close() throws Exception {
        this.writer.close();
    }

    public FileInfo getFileInfo() {
        return this.writer.getFileInfo();
    }
}

