/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.spatial.geofeature;

import com.northpool.exception.Message;
import com.northpool.spatial.geofeature.GeoBuffer;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;

public class GeoFeature<T> {
    private T geo;
    private Object[] property;
    double[] bbox;
    static final ThreadLocal<WKBReader> wkbReaderLocal = new ThreadLocal();

    public Object[] getProperty() {
        return this.property;
    }

    public double[] getBbox() {
        if (this.bbox != null) {
            return this.bbox;
        }
        if (this.geo instanceof Geometry) {
            Envelope envelope = ((Geometry)this.geo).getEnvelopeInternal();
            this.bbox = new double[]{envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY()};
        } else if (this.geo instanceof GeoBuffer) {
            this.bbox = ((GeoBuffer)this.geo).getBBOX();
        }
        return this.bbox;
    }

    public T getGeo() {
        return this.geo;
    }

    public Geometry getGeometry() {
        if (this.geo instanceof Geometry) {
            return (Geometry)this.geo;
        }
        if (this.geo instanceof GeoBuffer) {
            return ((GeoBuffer)this.geo).toJTSGeometry();
        }
        if (this.geo instanceof byte[]) {
            try {
                return GeoFeature.getWkbReader().read((byte[])this.geo);
            }
            catch (ParseException e) {
                throw new Message("wkb\u89e3\u6790\u5931\u8d25");
            }
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684GeoFeature\u7c7b\u578b" + this.geo.getClass().getName());
    }

    public GeoFeature(Object[] property, T geo) {
        this.property = property;
        this.geo = geo;
    }

    public GeoFeature(Object[] property, T geo, double[] bbox) {
        this.property = property;
        this.geo = geo;
        this.bbox = bbox;
    }

    private static WKBReader getWkbReader() {
        WKBReader reader = wkbReaderLocal.get();
        if (reader == null) {
            reader = new WKBReader();
            wkbReaderLocal.set(reader);
        }
        return reader;
    }
}

