/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.commons.reflect.beanHolder;

import com.northpool.commons.reflect.Bean;
import com.northpool.commons.reflect.BeanHolder;
import com.northpool.commons.reflect.FieldHolder;
import com.northpool.commons.reflect.beanHolder.BeanHolderImpl;
import com.northpool.commons.reflect.beanHolder.BeanNotFindException;
import com.northpool.commons.reflect.beanHolder.FieldHoder.FieldHolderImpl;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractBeanHolderImpl<T>
implements BeanHolder<T> {
    protected Class<T> clazz;
    protected BeanInfo beanInfo;
    protected HashMap<String, FieldHolder> fieldHolderMap = new HashMap();
    protected HashMap<String, FieldHolder> privateFieldHolderMap = new HashMap();

    public AbstractBeanHolderImpl(Class<T> clazz) {
        PropertyDescriptor[] props;
        this.clazz = clazz;
        try {
            this.beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            throw new BeanNotFindException(clazz.getName());
        }
        for (PropertyDescriptor propertyDescriptor : props = this.beanInfo.getPropertyDescriptors()) {
            String propertyName = propertyDescriptor.getName();
            if (propertyName.equalsIgnoreCase("class")) continue;
            FieldHolder fieldHolder = this.createFieldHolder(propertyDescriptor);
            this.fieldHolderMap.put(propertyName, fieldHolder);
        }
        this.addPublicFields(this.fieldHolderMap);
        this.privateFieldHolderMap(this.privateFieldHolderMap);
    }

    protected void privateFieldHolderMap(HashMap<String, FieldHolder> fieldHolderMap) {
        Field[] fieldArray;
        for (Field field : fieldArray = this.clazz.getDeclaredFields()) {
            String name;
            if (Modifier.isStatic(field.getModifiers()) || fieldHolderMap.get(name = field.getName()) != null) continue;
            FieldHolder fieldHolder = this.createFieldHolder(field);
            fieldHolderMap.put(name, fieldHolder);
        }
        Class<T> superClass = this.clazz.getSuperclass();
        if (superClass != null) {
            BeanHolderImpl beanHolderImpl = (BeanHolderImpl)Bean.getBeanHolder(superClass);
            this.privateFieldHolderMap.putAll(beanHolderImpl.privateFieldHolderMap);
        }
    }

    protected void addPublicFields(HashMap<String, FieldHolder> fieldHolderMap) {
        Field[] fieldArray;
        for (Field field : fieldArray = this.clazz.getFields()) {
            String name;
            if (Modifier.isStatic(field.getModifiers()) || fieldHolderMap.get(name = field.getName()) != null) continue;
            FieldHolder fieldHolder = this.createFieldHolder(field);
            fieldHolderMap.put(name, fieldHolder);
        }
    }

    protected FieldHolder createFieldHolder(PropertyDescriptor propertyDescriptor) {
        return new FieldHolderImpl<T>(propertyDescriptor, this.clazz, this);
    }

    protected FieldHolder createFieldHolder(Field field) {
        return new FieldHolderImpl<T>(field, this.clazz, this);
    }

    protected Field getFieldByName(Class clazz, String fieldName, Boolean findParent) {
        Field f;
        block3: {
            f = null;
            try {
                f = clazz.getDeclaredField(fieldName);
            }
            catch (SecurityException e) {
                e.printStackTrace();
                throw e;
            }
            catch (NoSuchFieldException e) {
                if (!findParent.booleanValue()) break block3;
                f = this.getFieldByName(clazz.getSuperclass(), fieldName, findParent);
            }
        }
        return f;
    }

    @Override
    public FieldHolder getFieldHolder(String fieldName) {
        return this.getFieldMap().get(fieldName);
    }

    @Override
    public Map<String, FieldHolder> getFieldMap() {
        return this.fieldHolderMap;
    }

    @Override
    public T getNewInstance() {
        try {
            this.clazz.newInstance();
            return this.clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Map<String, FieldHolder> getPrivateFieldMap() {
        return this.privateFieldHolderMap;
    }

    public static void main(String[] aaa) {
        BeanHolderImpl<Exception> BeanHolder2 = new BeanHolderImpl<Exception>(Exception.class);
        Map<String, FieldHolder> m = BeanHolder2.getPrivateFieldMap();
        System.out.print(m);
    }
}

