/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.spatial.grid.impl;

import com.northpool.exception.Message;
import com.northpool.spatial.grid.Constants;
import com.northpool.spatial.grid.IGridSystem;
import com.northpool.spatial.grid.extent.GridExtent;
import com.northpool.spatial.grid.extent.impl.GridExtentImpl;
import com.northpool.spatial.grid.impl.quadtreegrid.TdtDegrees512;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.proj4j.CRSFactory;
import org.locationtech.proj4j.CoordinateReferenceSystem;

public abstract class AbstractGrid
implements IGridSystem {
    protected int MAX_TILE_LEVEL = 30;
    protected Constants.GRID_UNIT unit;
    protected String name;
    protected int base;
    protected double resolutionLevelBegin;
    protected double minX;
    protected double minY;
    protected double maxX;
    protected double maxY;
    protected int beginLevel;
    protected int maxLevel;
    static final CRSFactory csFactory = new CRSFactory();
    static final String cgcs2000DegreeProj = "+proj=longlat +ellps=GRS80 +no_defs";
    static final String webMercProj = "+proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +wktext +no_defs";
    static final CoordinateReferenceSystem cs_cgcs2000Degree = csFactory.createFromParameters("cgcs2000Degree", "+proj=longlat +ellps=GRS80 +no_defs");
    static final CoordinateReferenceSystem cs_webMerc = csFactory.createFromParameters("webMerc", "+proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +wktext +no_defs");

    @Override
    public Constants.GRID_UNIT getUnit() {
        return this.unit;
    }

    @Override
    @Deprecated
    public int getBase() {
        return this.base;
    }

    @Override
    @Deprecated
    public GridExtent getExtent(int level, int x, int y) {
        double resolution = this.getResolution(level);
        double standard = (double)this.base * resolution;
        double left = this.minX + (double)x * standard;
        double right = this.minX + (double)(x + 1) * standard;
        double top = this.maxY - (double)y * standard;
        double bottom = this.maxY - (double)(y + 1) * standard;
        return new GridExtentImpl(left, bottom, right, top, level, this, x, y);
    }

    @Override
    public GridExtent getGridExtentByKey(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        String[] splits = key.split("_");
        if (splits.length != 3) {
            throw new Message("\u9519\u8bef\u7684key\uff1a" + key);
        }
        int level = Integer.valueOf(splits[0]);
        int x = Integer.valueOf(splits[1]);
        int y = Integer.valueOf(splits[2]);
        return this.getGridExtent(level, x, y);
    }

    @Override
    public GridExtent getGridExtent(int level, int x, int y) {
        double top;
        double bottom;
        Double resolution = this.getResolution(level);
        if (resolution == null) {
            throw new RuntimeException("\u7f51\u683c\u6ca1\u6709\u5c42\u7ea7" + level);
        }
        double standard = (double)this.base * resolution;
        double left = this.minX + (double)x * standard;
        double right = this.minX + (double)(x + 1) * standard;
        if (this.unit == Constants.GRID_UNIT.pixel) {
            bottom = this.minY + (double)(y + 1) * standard;
            top = this.minY + (double)y * standard;
        } else {
            top = this.maxY - (double)y * standard;
            bottom = this.maxY - (double)(y + 1) * standard;
        }
        return new GridExtentImpl(left, bottom, right, top, level, this, x, y);
    }

    @Override
    public int getBeginLevel() {
        return this.beginLevel;
    }

    public GridExtent getExtentByXY(int level, double x, double y) {
        x = x < this.minX ? this.minX : x;
        y = y > this.maxY ? this.maxY : y;
        x = x > this.maxX ? this.maxX : x;
        y = y < this.minY ? this.minY : y;
        double resolution = this.getResolution(level);
        int extentX = (int)this.calculateX(resolution, x);
        int extentY = (int)this.calculateY(resolution, y);
        return this.getGridExtent(level, extentX, extentY);
    }

    public GridExtent getGridExtentByLonLat(int level, double lon, double lat) {
        return this.getExtentByXY(level, lon, lat);
    }

    public String getName() {
        return this.name;
    }

    public double getBeginResolution() {
        return this.resolutionLevelBegin;
    }

    @Override
    public int getBaseTileSize() {
        return this.base;
    }

    @Override
    public double getMinX() {
        return this.minX;
    }

    @Override
    public double getMinY() {
        return this.minY;
    }

    @Override
    public double getMaxX() {
        return this.maxX;
    }

    @Override
    public double getMaxY() {
        return this.maxY;
    }

    @Override
    public double calculateX(double resolution, double x) {
        return (x - this.getMinX()) / resolution / (double)this.base;
    }

    @Override
    public double calculateY(double resolution, double y) {
        if (this.unit == Constants.GRID_UNIT.pixel) {
            return (y - this.minY) / resolution / (double)this.base;
        }
        return (this.getMaxY() - y) / resolution / (double)this.getBase();
    }

    @Override
    public String getBBox() {
        return "" + this.minX + ',' + this.minY + ',' + this.maxX + ',' + this.maxY;
    }

    @Override
    public int getFitableBeginLevel(double[] bbox) {
        double resolutionForLevel;
        double dx_bbox = bbox[2] - bbox[0];
        double dy_bbox = bbox[3] - bbox[1];
        if (dx_bbox < 0.0 || dy_bbox < 0.0) {
            return -1;
        }
        double mark_bbox = Math.max(dy_bbox, dx_bbox);
        double resolution = mark_bbox / (double)this.base;
        int level = this.getBeginLevel();
        while (!((resolutionForLevel = this.getResolution(level).doubleValue()) < resolution)) {
            if (++level <= this.MAX_TILE_LEVEL) continue;
            return -2;
        }
        return level - 1;
    }

    @Override
    public void setMinX(int minX) {
        this.minX = minX;
    }

    @Override
    public void setMaxY(int maxY) {
        this.maxY = maxY;
    }

    @Override
    public String getPointToTileString(double x, double y, int level) {
        double resolution = this.getResolution(level);
        Double _x = Double.valueOf(x - this.minX) / (resolution * (double)this.base);
        Double _y = Double.valueOf(this.maxY - y) / (resolution * (double)this.base);
        return _x.intValue() + "_" + _y.intValue() + "_" + level;
    }

    @Override
    public GridExtent getPointToTile(double x, double y, int level) {
        double resolution = this.getResolution(level);
        Double _x = Double.valueOf(x - this.minX) / (resolution * (double)this.base);
        Double _y = Double.valueOf(this.maxY - y) / (resolution * (double)this.base);
        return this.getGridExtent(level, _x.intValue(), _y.intValue());
    }

    public static void main(String[] aaa) {
        TdtDegrees512 tdtDegree512 = new TdtDegrees512();
        GridExtent gridExtent = tdtDegree512.getExtentByXY(9, 118.21702680400006, 27.83354398000027);
        System.out.println(gridExtent.getX() + " " + gridExtent.getY());
    }

    @Override
    public List<GridExtent> getGridExtentsByBBox(int level, double minX, double minY, double maxX, double maxY) {
        int minExtentY;
        GridExtent rightTopExtent;
        GridExtent leftBottomExtent;
        ArrayList<GridExtent> extents = new ArrayList<GridExtent>();
        if (this.unit == Constants.GRID_UNIT.pixel) {
            leftBottomExtent = this.getGridExtentByLonLat(level, minX, maxY);
            rightTopExtent = this.getGridExtentByLonLat(level, maxX, minY);
        } else {
            leftBottomExtent = this.getGridExtentByLonLat(level, minX, minY);
            rightTopExtent = this.getGridExtentByLonLat(level, maxX, maxY);
        }
        int minExtentX = leftBottomExtent.getX();
        int maxExtentY = leftBottomExtent.getY();
        int maxExtentX = rightTopExtent.getX();
        for (int extentY = minExtentY = rightTopExtent.getY(); extentY <= maxExtentY; ++extentY) {
            int extentX = minExtentX;
            while (extentX <= maxExtentX) {
                int currentX = extentX++;
                int currentY = extentY;
                GridExtent currentExtent = this.getGridExtent(level, currentX, currentY);
                extents.add(currentExtent);
            }
        }
        return extents;
    }

    @Override
    public CoordinateReferenceSystem getProj() {
        if (this.unit == Constants.GRID_UNIT.pixel) {
            throw new RuntimeException("pixel\u6ca1\u6709proj");
        }
        if (this.unit == Constants.GRID_UNIT.degree) {
            return cs_cgcs2000Degree;
        }
        if (this.unit == Constants.GRID_UNIT.meter) {
            return cs_webMerc;
        }
        throw new RuntimeException("\u4e0d\u652f\u6301 " + (Object)((Object)this.unit) + " \u83b7\u5f97proj");
    }
}

