/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.type;

import com.northpool.exception.NotSupport;
import com.northpool.type.AbstractType;
import com.northpool.type.Type;
import com.northpool.type.Types;
import java.math.BigDecimal;

public class TypeBoolean
extends AbstractType
implements Type {
    public static final TypeBoolean INSTANCE = new TypeBoolean();

    public TypeBoolean() {
        super(Types.TYPE_ENUM.Boolean);
    }

    @Override
    public String name() {
        return Types.TYPE_ENUM.Boolean.name();
    }

    @Override
    public Class<?> getJavaClass() {
        return Boolean.class;
    }

    @Override
    public boolean isType(Object o) {
        if (o == null) {
            return false;
        }
        return o instanceof Boolean;
    }

    @Override
    public Object strToType(String str) {
        if (this.stringNull(str)) {
            return null;
        }
        if ("1".equals(str)) {
            return true;
        }
        if ("0".equals(str)) {
            return false;
        }
        return Boolean.valueOf(str);
    }

    @Override
    public String valueToString(Object o) {
        this.testType(this, o);
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    @Override
    public Object toType(Object o) {
        if (o == null) {
            return null;
        }
        if (this.isType(o)) {
            return o;
        }
        return this.strToType(o.toString());
    }

    Object booleanToNumber(Type type, Object o) {
        boolean bValue = (Boolean)this.toType(o);
        if (type.getEnum() == Types.TYPE_ENUM.Integer) {
            if (bValue) {
                return 1;
            }
            return 0;
        }
        if (type.getEnum() == Types.TYPE_ENUM.Short) {
            if (bValue) {
                return (short)1;
            }
            return (short)0;
        }
        if (type.getEnum() == Types.TYPE_ENUM.Double) {
            if (bValue) {
                return 1.0;
            }
            return 0.0;
        }
        if (type.getEnum() == Types.TYPE_ENUM.Float) {
            if (bValue) {
                return Float.valueOf(1.0f);
            }
            return Float.valueOf(0.0f);
        }
        if (type.getEnum() == Types.TYPE_ENUM.Long) {
            if (bValue) {
                return 1L;
            }
            return 0L;
        }
        if (type.getEnum() == Types.TYPE_ENUM.BigDecimal) {
            if (bValue) {
                return new BigDecimal(1);
            }
            return new BigDecimal(0);
        }
        return null;
    }

    @Override
    public Boolean isTypePrimitive(Object o) {
        return o.getClass().equals(Boolean.TYPE);
    }

    @Override
    Object nativeChange(Object o) {
        return (boolean)((Boolean)o);
    }

    @Override
    Object numberChange(Number o) {
        throw new NotSupport();
    }
}

