package com.northpool.resources.datasource.db;

import java.util.HashMap;
import java.util.Map;

import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.dialect.db.SQLDialect;


public class DataSourceTemplate {
	protected String poolType;
	protected Map<String,String> propertys;
	public void setPoolType(String poolType) {
		this.poolType = poolType;
	}
	public void setPropertys(Map<String,String> propertys) {
		this.propertys = propertys;
	}
	/**
	 * 获得数据库资源连接参数
	 * 根据注册的类的类型获得相应的链接参数
	 * 本方法会将输入的链接参数转换为注册时连接池需要的参数
	 * 供给参数连接池所用
	 * @param url 地址
	 * @param username 用户名
	 * @param password 密码
	 * @param other 其他参数，会覆盖默认参数
	 * @return
	 * @throws Exception 
	 */
	public Map<String,String> getDataSourceConfig(String url,DATA_SOURCE_TYPE type,String username,String password,Map<String,String> other){
			
		if("DRUID".equalsIgnoreCase(poolType)){
			return this.doDRUID(url,type,username,password,other);
		}
		return null;
	}
	
	private Map<String,String> doDRUID(String url,DATA_SOURCE_TYPE type,String username,String password,Map<String,String> other) {
		SQLDialect dialect = SQLDialect.getSQLDialect(type);
		url = dialect.createConnectUrl(url);
		String driver = dialect.getJDBCDriver();
		Map<String,String> m = new HashMap<String,String>();
		m.putAll(this.propertys);
		if(other != null){
			m.putAll(other);
		}
		m.put("driverClassName", driver);
		m.put("url", url);
		m.put("username", username);
		m.put("password", password);
		
		return m;
	}
	
	
	
}
