package com.northpool.resources.datasource.db;




import com.alibaba.fastjson.JSON;
import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.datasource.ADataSource;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.db.operate.DBDataSourceOperaterManager;
import com.northpool.resources.datasource.db.operate.IDBDataSourceOperater;
import com.northpool.resources.datatable.FieldEncoder;
import com.northpool.resources.datatable.ITable;
import com.northpool.resources.datatablebuilder.BuilderManager;
import com.northpool.resources.datatablebuilder.ITableBuilder;
import com.northpool.resources.datatablebuilder.TableSchemaBean;
import com.northpool.resources.dialect.db.SQLDialect;
import com.northpool.resources.sql.SQLGenericDao;
import com.northpool.resources.sql.jdbc.SQLGenericDaoImpl;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.util.List;


/**
 * 
 * 
 * @author matt
 *
 */ 
@ADataSource(name = "db" ,types = "oracle,postgreSQL,kingbase,mysql,mysql8.0")
public class DbDataSource implements IDataSource {
	
	/**
	 * ID
	 */
	protected String id;
	
	/**
	 * url地址
	 */
	protected String url;
	/**
	 * 账号
	 */
	protected String user;
	/**
	 * 密码
	 */
	protected String password;
	/**
	 * 数据库类型
	 */
	protected DATA_SOURCE_TYPE dataSourceType;
	
	
	
	protected String poolName = DBPoolParameter.DEFAULT_POOL_NAME;
	

	protected String version;
	
	 @Deprecated
	    /**
	     * 序列化专用，禁止使用本方法初始化
	     */
	public DbDataSource(){
		
	}
	
	public DbDataSource(String id,String url,String user,String password,DATA_SOURCE_TYPE dataSourceType){
		this.id = id;
		this.url = url;
		this.user = user;
		this.password = password;
		this.dataSourceType = dataSourceType;
	}
	
	@Override
	public DATA_SOURCE_TYPE getDataSourceType() {
		return dataSourceType;
	}
	
	public void setDataSourceType(DATA_SOURCE_TYPE dataSourceType) {
		this.dataSourceType = dataSourceType;
	}
	@Override
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getUser() {
		return user;
	}

	public void setUser(String user) {
		this.user = user;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}
	@Override
	public String toString() {
		return new StringBuilder().append(this.dataSourceType.name()).append('_').append(this.processURL(this.url)).append('_').append(this.user).toString();
	}
	
	protected String processURL(String url){
		url = url.replaceAll("\\/", "@");
		return url;
	}

	
	public void setType(DATA_SOURCE_TYPE dataSourceType){
		this.dataSourceType = dataSourceType;
	}

	/**
	 * 创建新连接池
	 * @param poolName
	 * @param poolPropertys
	 * @return
	 */
	public DbDataSource getDbDataSourcePool(String poolName){
	    DbDataSource dbDataSource = new DbDataSource( this.id,this.url,this.user,this.password,this.dataSourceType);
	    dbDataSource.poolName = poolName;
	    
	    return dbDataSource;
	}
	
	

	@Override
	public String toJson(){
		return JSON.toJSON(this).toString();
	}
	@Override
	public DbDataSource createByJson(String json){
		return JSON.parseObject(json,DbDataSource.class);
	}
	

	@Override
	public String mark() {
		// TODO Auto-generated method stub
		return this.toString();
	}
	
	//public DataSource dataSource = JDBCPoolManager.getInstance().getDataSourcePool(dbDataSource.getDataSourceType(), dbDataSource.get, user, password, other);
	@SuppressWarnings("unchecked")
	@Override
	public javax.sql.DataSource connection() {
		javax.sql.DataSource dataSource = JDBCPoolManager.getInstance().getPool(this);
		return dataSource;
	}
	@Override
	public synchronized void resetConnection() {
		JDBCPoolManager.getInstance().remove(this.dataSourceType, url, user,this.password);
	}
	@Override
	public synchronized void destory(){
		JDBCPoolManager.getInstance().remove(this.dataSourceType, url, user,this.password);
	}
	
	public SQLGenericDao genericDao() {
		return new SQLGenericDaoImpl(this);
	}
	@Override
	public ITableBuilder getTableBuilder(String tableName) throws Exception {
		return BuilderManager.getInstance().getTableBuilder(this, tableName,null);
	}
	
	
	@Override
    public ITableBuilder getTableBuilder(String schema,String tableName) throws Exception {
	    tableName = SQLDialect.getSQLDialect(this.getDataSourceType()).processTableNameAndSchema(schema, tableName);
        return BuilderManager.getInstance().getTableBuilder(this, tableName,null);
    }
	
	
	

	@Override
	public void testConnection() throws Exception {
		// TODO Auto-generated method stub
		
		JDBCPoolManager.getInstance().inValid(this.dataSourceType, url, user, password);
		
	}


	@Override
	public boolean equals(Object o) {
		if (this == o) {
		    return true;
		}

		if (o == null || getClass() != o.getClass()) {
		    return false;
		}

		DbDataSource that = (DbDataSource) o;

		return new EqualsBuilder()
				.append(url, that.url)
				.append(user, that.user)
				.append(password, that.password)
				.append(dataSourceType, that.dataSourceType)
				.isEquals();
	}

	@Override
	public int hashCode() {
		return new HashCodeBuilder(17, 37)
				.append(url)
				.append(user)
				.append(password)
				.append(dataSourceType)
				.toHashCode();
	}

   
    @Override
    public ITable getTable(String tableName) throws Exception {
        // TODO Auto-generated method stub
        return this.getTableBuilder(tableName).getTable();
    }

   
    @Override
    public ITable getTable(String tableName, FieldEncoder fieldEncoder) throws Exception {
        // TODO Auto-generated method stub
        return this.getTableBuilder(tableName).getTable(fieldEncoder);
    }

    
    @Override
    public ITable getTable(String tableName,String[] selectFields) throws Exception {
        // TODO Auto-generated method stub
        return this.getTableBuilder(tableName).getTable(selectFields);
    }

   
    @Override
    public String[] tables() {
        // TODO Auto-generated method stub
        return this.getDBDataSourceOperater().tables(this);
    }

   
    @Override
    public void drop(String tableName) {
        // TODO Auto-generated method stub
        this.getDBDataSourceOperater().drop(this,tableName);
    }

 
    @Override
    public void createTableByBuilderBean(TableSchemaBean tableSchemaBean) {
        // TODO Auto-generated method stub
        this.getDBDataSourceOperater().createTableByBuilderBean(this,tableSchemaBean);
    }

    private IDBDataSourceOperater getDBDataSourceOperater(){
        IDBDataSourceOperater dataSourceOperater = DBDataSourceOperaterManager.get(this);
        if(dataSourceOperater == null){
            throw new RuntimeException("没有针对于" + this.dataSourceType.name() + "数据源的IDataSourceOperater操作类");
        }
        return dataSourceOperater;
    }
    
    public List<String> schemas(){
       return this.getDBDataSourceOperater().schemas(this);
    }

    @Override
    public Boolean hasSchema(String schema) {
        return this.getDBDataSourceOperater().hasSchema(this,schema);
    }
    
    public SQLGenericDao sqlGenericDao(){
        return new SQLGenericDaoImpl(this);
    }

  
    @Override
    public Boolean hasTable(String tableName) {
        return this.getDBDataSourceOperater().hasTable(this,tableName);
    }


	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}
}
