/**
　 * <p>Title: AbstractDBDataSourceOperater.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2020年11月26日
　 * @version 1.0
*/
package com.northpool.resources.datasource.db.operate;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import com.northpool.resources.datasource.db.DbDataSource;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatablebuilder.ITableBuilder;
import com.northpool.resources.datatablebuilder.TableSchemaBean;
import com.northpool.resources.dialect.db.SQLDialect;


/**
 * @author matt
 *
 */
public abstract class AbstractDBDataSourceOperater implements IDBDataSourceOperater {
    
    public abstract String getSchemaWhenGetTables(DbDataSource pool);
    
    public abstract String getTableName(String schema,String tableName);
    
    
    @Override
    public String[] tables(DbDataSource pool) {

        String schema = this.getSchemaWhenGetTables(pool);

        javax.sql.DataSource dataSource = pool.connection();
        Connection connection = null;
        DatabaseMetaData databaseMetaData;
        ResultSet ts = null;
        try {
            List<String> list = new ArrayList<>();
            connection = dataSource.getConnection();
            databaseMetaData = connection.getMetaData();
            ts = databaseMetaData.getTables(null, schema, null, null);
            while (ts.next()) {
                String tableName = ts.getString("TABLE_NAME");
                
              
            }
            return list.toArray(new String[list.size()]);
        } catch (SQLException e) {
            throw new DataAccessException(e);
        } finally {
            try {
                ts.close();
                
            } catch (SQLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            try {
                connection.close();
            } catch (SQLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
    }

   
    @Override
    public void drop(DbDataSource pool,String tableName) {
        // TODO Auto-generated method stub
        
    }

 
    @Override
    public void createTableByBuilderBean(DbDataSource pool,TableSchemaBean tableSchemaBean) {
        // TODO Auto-generated method stub
        
    }

    
    public List<String> schemas(DbDataSource pool){
        javax.sql.DataSource dataSource = pool.connection();
        Connection connection = null;
        DatabaseMetaData databaseMetaData;
        ResultSet set = null;
        try {
            connection = dataSource.getConnection();
            databaseMetaData = connection.getMetaData();
            set = databaseMetaData.getSchemas();
            ArrayList<String> schemas = new ArrayList<String>();
            while (set.next()) {
                schemas.add(set.getString("TABLE_SCHEM"));
            }
            return schemas; 
        } catch (SQLException e) {
            throw new DataAccessException(e);
        } finally {
            try {
                set.close();
                
            } catch (SQLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            try {
                connection.close();
            } catch (SQLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            
        }

    }
    
    
   
    @Override
    public Boolean hasSchema(DbDataSource pool,String schema) {
        return true;
    }
    
   

  
    @Override
    public Boolean hasTable(DbDataSource pool,String tableName) {
        // TODO Auto-generated method stub
        // TODO Auto-generated method stub
        String[] arr = tableName.split("\\.");
        String schema = null;
        
        if(arr.length > 1){
            schema = arr[0];
            tableName = arr[1];
        }else{
            schema = SQLDialect.getSQLDialect(pool.getDataSourceType()).getDefaultSchema();
        }

        
        javax.sql.DataSource dataSource = pool.connection();
        Connection connection = null;
        DatabaseMetaData databaseMetaData;
        ResultSet set = null;
        try {
            connection = dataSource.getConnection();
            databaseMetaData = connection.getMetaData();
            set = databaseMetaData.getTables(null, schema, tableName, new String[] { "TABLE" });
            return set.first(); 
        } catch (SQLException e) {
            throw new DataAccessException(e);
        } finally {
            try {
                set.close();
                
            } catch (SQLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            try {
                connection.close();
            } catch (SQLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
    }
}
