/**
　 * <p>Title: DBDataSourceOperaterManager.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2020年11月27日
　 * @version 1.0
*/
package com.northpool.resources.datasource.db.operate;

import java.util.HashMap;
import java.util.Set;

import com.northpool.commons.reflect.Bean;
import com.northpool.commons.util.PackageUtil;

import com.northpool.resources.Constants.DATA_SOURCE_TYPE;

import com.northpool.resources.datasource.db.DbDataSource;
import com.northpool.resources.datatablebuilder.ATableBuilder;

/**
 * @author matt
 *
 */
public class DBDataSourceOperaterManager {
    final static HashMap<DATA_SOURCE_TYPE,IDBDataSourceOperater> MAP;
    static {
        Set<Class<?>> classSet = null;
        try {
            classSet = PackageUtil.findClassAnnotation("com.northpool.resources.datasource.db.operate", ATableBuilder.class);
        } catch (ClassNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        
        MAP = new HashMap<DATA_SOURCE_TYPE,IDBDataSourceOperater>();
        classSet.forEach( clazz ->{
            
            ATableBuilder annotation = clazz.getAnnotation(ATableBuilder.class);
           
            if(!Bean.isInstance(clazz, IDBDataSourceOperater.class)){
                throw new RuntimeException(clazz.getName() + "不是接口 IDataSource实现类");
            }
            @SuppressWarnings("unchecked")
            Class<? extends IDBDataSourceOperater> clazz0 = (Class<? extends IDBDataSourceOperater>)clazz;
            
            DATA_SOURCE_TYPE type = annotation.type();
            
            MAP.put(type, Bean.newInstance(clazz0));

        });
    }
    
    
    
    
    
    
    public static IDBDataSourceOperater get(DbDataSource pool){
        DATA_SOURCE_TYPE type = pool.getDataSourceType();
        return MAP.get(type);
    }
}
