/**
　 * <p>Title: AbstractDBDAO.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2020年11月4日
　 * @version 1.0
*/
package com.northpool.resources.datatable.db;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.ArrayUtils;

import com.northpool.commons.reflect.Bean;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.command.Constants.OPERATION;
import com.northpool.resources.datasource.db.DbDataSource;
import com.northpool.resources.datatable.IField;
import com.northpool.resources.datatable.Scroll;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatable.dao.IDAO;
import com.northpool.resources.datatablebuilder.db.IDBTableBuilder;
import com.northpool.resources.sql.SQLParameter;
import com.northpool.resources.sql.SQLQueryEngine;
import com.northpool.resources.sql.jdbc.SQLGenericDaoImpl;
import com.northpool.resources.sql.jdbc.SQLTransformer;
import com.northpool.resources.sql.jdbc.UpdateDataScroll;
import com.northpool.resources.type.Type;

/**
 * @author matt
 *
 */
public class AbstractDBDAO<PK,T> extends SQLGenericDaoImpl implements IDAO<T,PK> {
    
    protected DBTable dbTable;
    
    protected Class<?> clazz;
    
    protected SQLTransformer<T> transformer; 
    
    public AbstractDBDAO(DbDataSource dbDataSource,DBTable dbTable,SQLTransformer<T> transformer) {
        super(dbDataSource);
        this.dbTable = dbTable;
        this.transformer = transformer;
    }
    
    
    protected void checkWriteable(){
        if(dbTable.getIsView()){
            throw new RuntimeException(dbTable.mark() + "为试图,不能执行写操作");
        }
    }
    
    
    
    public T get(PK pk) throws DataAccessException {
        // TODO Auto-generated method stub
        String idFiled = dbTable.getIdField();
        QueryFilter filter = new QueryFilter();
        filter.addFilter(idFiled, OPERATION.EQ,pk);
        List<T> ii = this.query(filter);
        if(ii.isEmpty()){
            return null;
        }
        return ii.get(0);
    }

    public List<T> query(QueryFilter filter) throws DataAccessException{
        return this.query(filter, null);
    }
   
    public Scroll<T> scroll(QueryFilter filter, Integer fetchSize) throws DataAccessException{
        return this._scroll(filter, fetchSize,this.transformer);
    }
    
    private <ST> Scroll <ST> _scroll(QueryFilter filter, Integer fetchSize,SQLTransformer<ST> transformer) throws DataAccessException {
        // TODO Auto-generated method stub
        SQLQueryEngine engine = null;
        try {
             engine = SQLQueryEngine.create(this.dbTable, filter);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();
        Scroll<ST> s = this.scrollBySql(parameter.getSql(), parameter.getValues(), parameter.getTypes(),parameter.getReturnTypeMap(),filter.getStart(),filter.getEnd(),fetchSize,transformer);
        return s;
    }
    
    
    public Long count(QueryFilter filter) throws DataAccessException {
        // TODO Auto-generated method stub
        SQLQueryEngine engine = null;
        try {
             engine = SQLQueryEngine.create(this.dbTable, filter);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();
        Long count = this.getCountBySql(parameter.getSql(), parameter.getValues(),parameter.getTypes());
        return count;
    }
    
    public void insert(T t) throws DataAccessException {
        this.insert(t, false);
    }
    
    public void insert(T t,Boolean insertNull) throws DataAccessException {
        // TODO Auto-generated method stub
        int size = this.dbTable.fields().length;
        String[] fieldsInDB = new String[size];
        String[] fields = new String[size];
        Type[] types = new Type[size];
        for(int index = 0 ; index < size ; index ++){
            IField field = this.dbTable.fields()[index];
            fieldsInDB[index] = field.getOriginFieldName();
            fields[index] = field.getFieldName();
            types[index] = field.getType();
        }
        Object[] args = null;
        if(insertNull){
            args = new Object[size];
           
            for(int i = 0 ; i < fieldsInDB.length ; i ++){
                String fieldInDB = fieldsInDB[i];
                String fieldName = fields[i];
                args[i] = Bean.getObjectValueByFieldName(t, fieldName);
            }
        }else{
            List<String> newFieldInDb = new ArrayList<>(size);
            List<Object> argsList = new ArrayList<>(size);
            List<Type> typeList = new ArrayList<>(size);
            for(int i = 0 ; i < fieldsInDB.length ; i ++){
                String fieldInDB = fieldsInDB[i];
                String fieldName = fields[i];
                Object o = Bean.getObjectValueByFieldName(t, fieldName);
                if(o != null){
                    newFieldInDb.add(fieldInDB);
                    argsList.add(o);
                    typeList.add(this.dbTable.getFieldsInTableMap().get(fieldInDB).getType());
                }
                
            }
            fieldsInDB = newFieldInDb.toArray(new String[newFieldInDb.size()]);
            args = argsList.toArray(new Object[argsList.size()]);
            types = typeList.toArray(new Type[typeList.size()]);
        }
        
        
        String sql = this.dialect.createInsertSQL(((IDBTableBuilder)this.dbTable.getTableBuilder()).getSchema(),this.dbTable.getTablename(), fieldsInDB);
        this.doExecuteSql(sql, args,types);
        return;
    }
    
    public void remove(PK pk) throws DataAccessException {
        String idFieldName = this.dbTable.getIdField();
        IField idField = this.dbTable.getFieldsMap().get(idFieldName);
        String idFieldNameInDB = idField.getOriginFieldName();
        String sql = this.dialect.createDeleteSQL(((IDBTableBuilder)this.dbTable.getTableBuilder()).getSchema(),this.dbTable.getTablename(), idFieldNameInDB + " = ?");
        this.doExecuteSql(sql, new Object[]{pk},new Type[]{idField.getType()});
    }
    
    public void update(T t) throws DataAccessException {
        // TODO Auto-generated method stub
        String idFieldName = this.dbTable.getIdField();
        String idFieldNameInDB = this.dbTable.getFieldsMap().get(idFieldName).getOriginFieldName();
        //String sql = this.dialect.createUpdateSQL(tableName, fields, where);
        
        int size = this.dbTable.fields().length;
        
        String[] fieldsInDB = new String[size ];
        String[] fields = new String[size - 1];
        Type[] types = new Type[size];
        Object[] args = new Object[size];
        int i = 0;
        for(int index = 0 ; index < this.dbTable.fieldSize() ; index ++){
            IField field = this.dbTable.fields()[index];
            if(field.isPK()){
                continue;
            }  
            fieldsInDB[i] = field.getOriginFieldName();
            fields[i] = field.getFieldName();
            types[i] = field.getType();
            args[i] = Bean.getObjectValueByFieldName(t, field.getFieldName());
            i++;
        }
        
        types[size - 1] = this.dbTable.getTableBuilder().getPKColumnInfo().getType();
        args[size - 1] = Bean.getObjectValueByFieldName(t,idFieldName);
        
        String sql = this.dialect.createUpdateSQL( ((IDBTableBuilder)this.dbTable.getTableBuilder()).getSchema(),this.dbTable.getTablename(), fields, idFieldNameInDB + " = ?");

        this.doExecuteSql(sql, args,types);
        
    }
    
    
    public void saveOrUpdate(T t) throws DataAccessException {
        PK pk = (PK)Bean.getObjectValueByFieldName(t, this.dbTable.getIdField());
        if(pk == null){
            this.insert(t);
        }
        T inDB = this.get(pk);
        if(inDB == null){
            this.insert(t);
        }else{
            this.update(t);
        }
    }
    
    
    public List<T> query(QueryFilter filter, Integer fetchSize) {
        return this._query(filter, fetchSize, this.transformer);
    }
    
    public Scroll<Object> scrollId(QueryFilter filter, Integer fetchSize) throws DataAccessException {
        filter.setOutputFieldNames(this.dbTable.getIdField());
        SQLQueryEngine engine = null;
        try {
             engine = SQLQueryEngine.create(this.dbTable, filter);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();
        
        
        return this.scrollBySql(parameter.getSql(), parameter.getValues(), parameter.getTypes(),parameter.getReturnTypeMap(),filter.getStart(),filter.getEnd(),fetchSize,SQLTransformer.ONEFILED);
    }
    
    
    public void update(PK pk, T t) throws DataAccessException {
        // TODO Auto-generated method stub
        String idFieldName = this.dbTable.getIdField();
        String idFieldNameInDB = this.dbTable.getFieldsMap().get(idFieldName).getOriginFieldName();
        //String sql = this.dialect.createUpdateSQL(tableName, fields, where);
        
        int size = this.dbTable.fields().length;
        
        String[] fieldsInDB = new String[size ];
        String[] fields = new String[size - 1];
        Type[] types = new Type[size];
        Object[] args = new Object[size];
        int i = 0;
        for(int index = 0 ; index < this.dbTable.fieldSize() ; index ++){
            IField field = this.dbTable.fields()[index];
            if(field.isPK()){
                continue;
            }  
            fieldsInDB[i] = field.getOriginFieldName();
            fields[i] = field.getFieldName();
            types[i] = field.getType();
            args[i] = Bean.getObjectValueByFieldName(t, field.getFieldName());
            i++;
        }
        
        types[size - 1] = this.dbTable.getTableBuilder().getPKColumnInfo().getType();
        args[size - 1] = pk;
        
        String sql = this.dialect.createUpdateSQL( ((IDBTableBuilder)this.dbTable.getTableBuilder()).getSchema(),this.dbTable.getTablename(), fields, idFieldNameInDB + " = ?");
        
        this.doExecuteSql(sql, args,types);
        
    }
    
    public void insertMany(final List<T> list,final Integer batchSize) throws DataAccessException{
        this.insertMany(list, true, batchSize);
    }
    
    public void insertMany(final List<T> list,final Boolean insertPK,final Integer batchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        int size = this.dbTable.fields().length;
        ArrayList<String> fieldsInDBArr = new ArrayList<>();
        ArrayList<String> fieldsArr = new ArrayList<>();
        ArrayList<Type> typesArr = new ArrayList<>();
        for(int index = 0 ; index < size ; index ++){
            IField field = this.dbTable.fields()[index];
            if(field.isPK() && !insertPK){
                continue;
            }
            fieldsInDBArr.add(field.getOriginFieldName());
            fieldsArr.add(field.getFieldName());
            typesArr.add(field.getType());
            
        }
        String[] fieldsInDB = fieldsInDBArr.toArray(new String[fieldsInDBArr.size()]);
        String[] fields = fieldsArr.toArray(new String[fieldsArr.size()]);
        Type[] types = typesArr.toArray(new Type[typesArr.size()]);
        
        String sql = this.dialect.createInsertSQL(((IDBTableBuilder)this.dbTable.getTableBuilder()).getSchema(),this.dbTable.getTablename(), fieldsInDB);
        UpdateDataScroll scroll = new UpdateDataScroll(){
            Iterator<T> iterator = list.iterator();
            @Override
            public boolean hasNext() {
                // TODO Auto-generated method stub
                return iterator.hasNext();
            }

            @Override
            public Object[] next() {
                T data = iterator.next();
                Object[] values = new Object[fields.length];
                // TODO Auto-generated method stub
                for(int i = 0 ; i < fields.length ; i ++){
                    String field = fields[i];
                    Object value = Bean.getObjectValueByFieldName(data, field);
                    values[i] = value;
                }
                return values;
            }

            @Override
            public int size() {
                // TODO Auto-generated method stub
                return list.size();
            }
            
        };
        this.doBatchExecuteSql(sql,types, scroll, batchSize);
        return;
        
    }
    
    
    public void insertMany(final List<Object[]> list,final String[] fields,final Integer batchSize) throws DataAccessException{
        String idFieldName = this.dbTable.getIdField();
        
        /*if(ArrayUtils.indexOf(fields, idFieldName) == -1){
            //没有在选择字段中寻找到主键，则需要报错
            throw new DataAccessException(String.format("字段中缺少主键%s",idFieldName));
        }*/
        /*int size = this.dbTable.fields().length;
        String[] fieldsInDB = new String[size];
        String[] fields = new String[size];
        Type[] types = new Type[size];
        for(int index = 0 ; index < size ; index ++){
            IField field = this.dbTable.fields()[index];
            fieldsInDB[index] = field.getOriginFieldName();
            fields[index] = field.getFieldName();
            types[index] = field.getType();
        }*/
        
        //List<String> fieldArr = new ArrayList<String>();
        
        String[] fieldsInDB = new String[fields.length];
        Type[] types = new Type[fields.length];
        Map<String,IField> mapField = dbTable.getFieldsMap();
        for(int i = 0 ; i < fields.length ; i++){
            String field = fields[i];
            IField dbField = mapField.get(field);
            if(dbField == null){
                throw new RuntimeException(String.format("表:%s中没有找到字段", dbTable.mark(),dbField));
            }
            fieldsInDB[i] = dbField.getOriginFieldName();
            types[i] = dbField.getType();
            
        }
      //  return fieldArr.toArray(new String[fieldArr.size()]);
        
        //String[] fieldsInDB = this.fieldToFieldInDB(fields);
        
        
        String sql = this.dialect.createInsertSQL(((IDBTableBuilder)this.dbTable.getTableBuilder()).getSchema(),this.dbTable.getTablename(), fieldsInDB);
    
        
        this.doBatchExecuteSql(sql, list,types, batchSize);
        
    }
    
    public Scroll<T> scroll(QueryFilter filter) throws DataAccessException {
        // TODO Auto-generated method stub
        return this.scroll(filter, null);
    }
    
    public void removeAll() throws DataAccessException {
        // TODO Auto-generated method stub
        
    }
    
    public void insertMany(List<T> list) throws DataAccessException {
        // TODO Auto-generated method stub
        this.insertMany(list, null);
    }
    
    public void updateMany(T t, QueryFilter queryFilter) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }
    
    public void remove(QueryFilter queryFilter) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }
    
    
    private <QT> List<QT> _query(QueryFilter filter, Integer fetchSize,SQLTransformer<QT> transformer) throws DataAccessException {
        
        SQLQueryEngine engine = null;
        try {
             engine = SQLQueryEngine.create(this.dbTable, filter);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();
        List<QT> i = this.queryBySql(parameter.getSql(), parameter.getValues(),parameter.getTypes(), parameter.getReturnTypeMap(),filter.getStart(),filter.getEnd(),fetchSize,transformer);
        return i;
    }
   
    public List<Object[]> queryArray(QueryFilter filter, Integer fetchSize) throws DataAccessException {
        
         return this._query(filter, fetchSize, SQLTransformer.ARRAY);
    }

   
    public Scroll<Object[]> scrollArray(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        return this._scroll(queryFilter, fetchSize, SQLTransformer.ARRAY);
    }
    
    
    
}
